/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.blocks.BlockFancySign;
import jds.bibliocraft.helpers.CustomBlockItemDataPack;
import jds.bibliocraft.items.ItemDrill;
import jds.bibliocraft.items.ItemLock;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityTable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BiblioBlock
extends BlockContainer {
    private String customTexture = "none";
    private CustomBlockItemDataPack customData = null;

    public BiblioBlock(Material material, SoundType sound, CreativeTabs tab, String name) {
        super(material);
        this.func_149672_a(sound);
        if (tab != null) {
            this.func_149647_a(tab);
        }
        this.func_149663_c("BiblioCraft:" + name);
        this.setRegistryName(name);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean returnValue = true;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof BiblioTileEntity) {
            BiblioTileEntity biblioTile = (BiblioTileEntity)tile;
            String playername = player.getDisplayNameString();
            boolean islocked = biblioTile.isLocked();
            String lockeename = biblioTile.getLockee();
            if (!world.field_72995_K) {
                ItemStack playerhand = player.func_184586_b(EnumHand.MAIN_HAND);
                if (playerhand != ItemStack.field_190927_a && playerhand.func_77973_b() instanceof ItemLock) {
                    if (islocked) {
                        if (playername.contains(lockeename)) {
                            biblioTile.setLocked(false);
                            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"lock.unlocked")));
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"lock.notowner")));
                        }
                    } else {
                        biblioTile.setLocked(true);
                        biblioTile.setLockee(playername);
                        player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"lock.locked")));
                    }
                    return true;
                }
                if (!islocked || playername.contains(lockeename)) {
                    if (playerhand != ItemStack.field_190927_a && playerhand.func_77973_b() instanceof ItemDrill && !(biblioTile instanceof TileEntityTable)) {
                        return false;
                    }
                    returnValue = this.onBlockActivatedCustomCommands(world, pos, state, player, side, hitX, hitY, hitZ);
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"lock.notowner")));
                }
            } else {
                returnValue = this.onBlockActivatedCustomCommands(world, pos, state, player, side, hitX, hitY, hitZ);
                ItemStack playerhand = player.func_184586_b(EnumHand.MAIN_HAND);
                if (playerhand != ItemStack.field_190927_a && playerhand.func_77973_b() instanceof ItemDrill) {
                    returnValue = false;
                }
            }
        }
        return returnValue;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public abstract boolean onBlockActivatedCustomCommands(World var1, BlockPos var2, IBlockState var3, EntityPlayer var4, EnumFacing var5, float var6, float var7, float var8);

    public abstract TileEntity func_149915_a(World var1, int var2);

    public abstract List<String> getModelParts(BiblioTileEntity var1);

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof BiblioTileEntity) {
            BiblioTileEntity biblioTile = (BiblioTileEntity)tile;
            this.customTexture = biblioTile.getCustomTextureString();
            this.customData = this.getCustomDataOnHarvest(biblioTile);
        }
    }

    public CustomBlockItemDataPack getCustomDataOnHarvest(BiblioTileEntity tile) {
        return new CustomBlockItemDataPack();
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> retern = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        TileEntity tile = world.func_175625_s(pos);
        int count = this.quantityDropped(state, fortune, rand);
        for (int i = 0; i < count; ++i) {
            NBTTagCompound tags;
            Item item = this.func_180660_a(state, rand, fortune);
            if (item == ItemStack.field_190927_a.func_77973_b()) continue;
            ItemStack newStack = new ItemStack(item, 1, this.func_180651_a(state));
            if (!this.customTexture.contentEquals("none") && !this.customTexture.contentEquals("")) {
                tags = new NBTTagCompound();
                tags.func_74778_a("renderTexture", this.customTexture);
                newStack.func_77982_d(tags);
            }
            if (this.customData != null && this.customData.hasData) {
                tags = new NBTTagCompound();
                if (newStack.func_77978_p() != null) {
                    tags = newStack.func_77978_p();
                }
                tags = this.customData.applyDataToItemStack(tags);
                newStack.func_77982_d(tags);
            }
            retern.add(newStack);
        }
        return retern;
    }

    public BlockPos getDropPositionOffset(BlockPos oldPos, EntityPlayer player) {
        BlockPos playerPos = player.func_180425_c();
        int x = oldPos.func_177958_n() - playerPos.func_177958_n();
        int z = oldPos.func_177952_p() - playerPos.func_177952_p();
        if (x > 1) {
            x = 1;
        }
        if (x < -1) {
            x = -1;
        }
        if (z > 1) {
            z = 1;
        }
        if (z < -1) {
            z = -1;
        }
        x = oldPos.func_177958_n() - x;
        z = oldPos.func_177952_p() - z;
        BlockPos pos = new BlockPos(x, oldPos.func_177956_o(), z);
        return pos;
    }

    public void dropStackInSlot(World world, BlockPos pos, int slot, BlockPos extractPos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        BiblioTileEntity biblioTile = (BiblioTileEntity)tileEntity;
        ItemStack stack = biblioTile.func_70301_a(slot);
        if (stack != ItemStack.field_190927_a && stack.func_190916_E() > 0) {
            float adjusti = 0.0f;
            float adjustk = 0.0f;
            switch (biblioTile.getAngle()) {
                case SOUTH: {
                    adjusti = -0.2f;
                    adjustk = 0.0f;
                    break;
                }
                case WEST: {
                    adjusti = 0.0f;
                    adjustk = -0.2f;
                    break;
                }
                case NORTH: {
                    adjusti = 0.2f;
                    adjustk = 0.0f;
                    break;
                }
                case EAST: {
                    adjusti = 0.0f;
                    adjustk = 0.2f;
                    break;
                }
                default: {
                    adjusti = 0.2f;
                    adjustk = 0.0f;
                }
            }
            EntityItem entityItem = new EntityItem(world, (double)((float)extractPos.func_177958_n() + 0.5f + adjusti), (double)((float)extractPos.func_177956_o() + 0.5f), (double)((float)extractPos.func_177952_p() + 0.5f + adjustk), new ItemStack(stack.func_77973_b(), stack.func_190916_E(), stack.func_77952_i()));
            if (stack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
            }
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            world.func_72838_d((Entity)entityItem);
            stack.func_190920_e(0);
        }
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        BiblioTileEntity tilee;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof BiblioTileEntity && (tilee = (BiblioTileEntity)tile).isLocked()) {
            return -1.0f;
        }
        return 3.0f;
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    @Deprecated
    public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        BiblioBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185890_d((IBlockAccess)worldIn, pos));
    }

    public EnumFacing getFacing(int angle) {
        EnumFacing face = EnumFacing.WEST;
        switch (angle) {
            case 0: {
                face = EnumFacing.SOUTH;
                break;
            }
            case 2: {
                face = EnumFacing.NORTH;
                break;
            }
            case 3: {
                face = EnumFacing.EAST;
            }
        }
        return face;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack itemStack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof BiblioTileEntity) {
            int angle = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            ++angle;
            BiblioTileEntity biblioTile = (BiblioTileEntity)world.func_175625_s(pos);
            biblioTile.setAngle(this.getFacing(angle %= 4));
            NBTTagCompound tags = itemStack.func_77978_p();
            if (tags != null) {
                if (tags.func_74764_b("renderTexture")) {
                    biblioTile.setCustomTexureString(tags.func_74779_i("renderTexture"));
                }
                if (tags.func_74764_b("textscale")) {
                    CustomBlockItemDataPack.applyDataToBlock(tags, biblioTile);
                }
            }
            this.additionalPlacementCommands(biblioTile, player);
        }
    }

    public abstract void additionalPlacementCommands(BiblioTileEntity var1, EntityLivingBase var2);

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!(state.func_177230_c() instanceof BlockFancySign)) {
            this.dropItems(world, pos);
        }
        super.func_180663_b(world, pos, state);
    }

    public void dropItems(World world, BlockPos pos) {
        Random rando = new Random();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int x = 0; x < inventory.func_70302_i_(); ++x) {
            ItemStack item = inventory.func_70301_a(x);
            if (item == ItemStack.field_190927_a || item.func_190916_E() <= 0) continue;
            float ri = rando.nextFloat() * 0.8f + 0.1f;
            float rj = rando.nextFloat() * 0.8f + 0.1f;
            float rk = rando.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + ri), (double)((float)pos.func_177956_o() + rj), (double)((float)pos.func_177952_p() + rk), new ItemStack(item.func_77973_b(), item.func_190916_E(), item.func_77952_i()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rando.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rando.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rando.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.func_190920_e(0);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult trace, World world, BlockPos pos, EntityPlayer player) {
        ItemStack item = this.func_185473_a(world, pos, state);
        if (item == ItemStack.field_190927_a) {
            return ItemStack.field_190927_a;
        }
        BiblioBlock block = item.func_77973_b() instanceof ItemBlock ? Block.func_149634_a((Item)item.func_77973_b()) : this;
        ItemStack stack = new ItemStack(item.func_77973_b(), 1, block.func_176201_c(state));
        stack = this.getPickBlockExtras(stack, world, pos);
        return stack;
    }

    public abstract ItemStack getPickBlockExtras(ItemStack var1, World var2, BlockPos var3);

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public EnumFacing[] getValidRotations(World worldObj, BlockPos pos) {
        EnumFacing[] axises = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};
        return axises;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        boolean returnValue = false;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof BiblioTileEntity) {
            BiblioTileEntity te = (BiblioTileEntity)tile;
            EnumFacing angle = te.getAngle();
            returnValue = true;
            switch (axis) {
                case DOWN: {
                    te.setAngle(angle.func_176746_e());
                    break;
                }
                case UP: {
                    te.setAngle(angle.func_176735_f());
                    break;
                }
                default: {
                    returnValue = false;
                }
            }
        }
        return returnValue;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{OBJModel.OBJProperty.INSTANCE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        ExtendedBlockState exstate = new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{OBJModel.OBJProperty.INSTANCE});
        exstate = this.getExtendedBlockStateAlternate(exstate);
        IExtendedBlockState newState = (IExtendedBlockState)exstate.func_177621_b();
        OBJModel.OBJState partList = new OBJModel.OBJState((List)Lists.newArrayList((Object[])new String[]{"OBJModel.Group.All.Key"}), true);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof BiblioTileEntity) {
            BiblioTileEntity biblioTile = (BiblioTileEntity)tile;
            List<String> modelParts = this.getModelParts(biblioTile);
            TRSRTransformation transform = new TRSRTransformation(biblioTile.getAngle());
            switch (biblioTile.getShiftPosition()) {
                case HALF_SHIFT: {
                    transform = transform.compose(new TRSRTransformation(new Vector3f(0.25f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
                    break;
                }
                case FULL_SHIFT: {
                    transform = transform.compose(new TRSRTransformation(new Vector3f(0.5f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
                    break;
                }
            }
            transform = this.getAdditionalTransforms(transform, biblioTile);
            partList = new OBJModel.OBJState(modelParts, true, (IModelState)transform);
            newState = newState.withProperty((IUnlistedProperty)OBJModel.OBJProperty.INSTANCE, (Object)partList);
            newState = this.getIExtendedBlockStateAlternate(biblioTile, newState);
        }
        return this.getFinalBlockstate(state, (IBlockState)newState);
    }

    public abstract IBlockState getFinalBlockstate(IBlockState var1, IBlockState var2);

    public abstract TRSRTransformation getAdditionalTransforms(TRSRTransformation var1, BiblioTileEntity var2);

    public abstract ExtendedBlockState getExtendedBlockStateAlternate(ExtendedBlockState var1);

    public abstract IExtendedBlockState getIExtendedBlockStateAlternate(BiblioTileEntity var1, IExtendedBlockState var2);

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        boolean output = false;
        if (layer == BlockRenderLayer.CUTOUT) {
            output = true;
        }
        return output;
    }

    public static boolean isFrontOfBlock(EnumFacing face, EnumFacing angle) {
        boolean returnValue = false;
        if (face == EnumFacing.SOUTH && angle == EnumFacing.EAST || face == EnumFacing.WEST && angle == EnumFacing.SOUTH || face == EnumFacing.NORTH && angle == EnumFacing.WEST || face == EnumFacing.EAST && angle == EnumFacing.NORTH) {
            returnValue = true;
        }
        return returnValue;
    }

    public static boolean isBackOfBlock(EnumFacing face, EnumFacing angle) {
        boolean returnValue = false;
        if (face == EnumFacing.SOUTH && angle == EnumFacing.WEST || face == EnumFacing.WEST && angle == EnumFacing.NORTH || face == EnumFacing.NORTH && angle == EnumFacing.EAST || face == EnumFacing.EAST && angle == EnumFacing.SOUTH) {
            returnValue = true;
        }
        return returnValue;
    }

    public static int getSlotNumberFromClickon2x2block(EnumFacing angle, float hitX, float hitY, float hitZ) {
        int xCheck = (int)(hitX * 2.0f);
        int yCheck = (int)(hitY * 2.0f);
        int zCheck = (int)(hitZ * 2.0f);
        int slot = -1;
        if (yCheck == 1 && zCheck == 0 && angle == EnumFacing.SOUTH || yCheck == 1 && xCheck == 1 && angle == EnumFacing.WEST || yCheck == 1 && zCheck == 1 && angle == EnumFacing.NORTH || yCheck == 1 && xCheck == 0 && angle == EnumFacing.EAST) {
            slot = 0;
        }
        if (yCheck == 1 && zCheck == 1 && angle == EnumFacing.SOUTH || yCheck == 1 && xCheck == 0 && angle == EnumFacing.WEST || yCheck == 1 && zCheck == 0 && angle == EnumFacing.NORTH || yCheck == 1 && xCheck == 1 && angle == EnumFacing.EAST) {
            slot = 1;
        }
        if (yCheck == 0 && zCheck == 0 && angle == EnumFacing.SOUTH || yCheck == 0 && xCheck == 1 && angle == EnumFacing.WEST || yCheck == 0 && zCheck == 1 && angle == EnumFacing.NORTH || yCheck == 0 && xCheck == 0 && angle == EnumFacing.EAST) {
            slot = 2;
        }
        if (yCheck == 0 && zCheck == 1 && angle == EnumFacing.SOUTH || yCheck == 0 && xCheck == 0 && angle == EnumFacing.WEST || yCheck == 0 && zCheck == 0 && angle == EnumFacing.NORTH || yCheck == 0 && xCheck == 1 && angle == EnumFacing.EAST) {
            slot = 3;
        }
        return slot;
    }

    public AxisAlignedBB getBlockBounds(float x1, float y1, float z1, float x2, float y2, float z2) {
        return new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }
}

