/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.potions;

import crafttweaker.api.entity.IEntity;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.potions.IPotion;
import crafttweaker.api.potions.IPotionEffect;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.potions.MCPotion;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class MCPotionEffect
implements IPotionEffect {
    private final PotionEffect potionEffect;

    public MCPotionEffect(PotionEffect potionEffect) {
        this.potionEffect = potionEffect;
    }

    @Override
    public int compareTo(IPotion other) {
        return this.potionEffect.compareTo((PotionEffect)other.getInternal());
    }

    @Override
    public int getDuration() {
        return this.potionEffect.func_76459_b();
    }

    @Override
    public IPotion getPotion() {
        return new MCPotion(this.potionEffect.func_188419_a());
    }

    @Override
    public boolean doesShowParticles() {
        return this.potionEffect.func_188418_e();
    }

    @Override
    public int getAmplifier() {
        return this.potionEffect.func_76458_c();
    }

    @Override
    public List<IItemStack> getCurativeItems() {
        return this.potionEffect.getCurativeItems().stream().map(MCItemStack::new).collect(Collectors.toList());
    }

    @Override
    public String getEffectName() {
        return this.potionEffect.func_76453_d();
    }

    @Override
    public boolean isAmbient() {
        return this.potionEffect.func_82720_e();
    }

    @Override
    public boolean isPotionDurationMax() {
        return this.potionEffect.func_100011_g();
    }

    @Override
    public boolean isCurativeItem(IItemStack item) {
        return this.potionEffect.isCurativeItem((ItemStack)item.getInternal());
    }

    @Override
    public void setIsPotionDurationMax(boolean potionDurationMax) {
        this.potionEffect.func_100012_b(potionDurationMax);
    }

    @Override
    public void performEffect(IEntity entity) {
        if (entity.getInternal() instanceof EntityLivingBase) {
            this.potionEffect.func_76457_b((EntityLivingBase)entity.getInternal());
        }
    }

    @Override
    public void combine(IPotionEffect other) {
        this.potionEffect.func_76452_a(CraftTweakerMC.getPotionEffect(other));
    }

    @Override
    public Object getInternal() {
        return this.potionEffect;
    }
}

