/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.proxy;

import com.mrcrayfish.furniture.client.GifCache;
import com.mrcrayfish.furniture.handler.ClientEvents;
import com.mrcrayfish.furniture.handler.GuiDrawHandler;
import com.mrcrayfish.furniture.handler.InputHandler;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.proxy.CommonProxy;
import com.mrcrayfish.furniture.render.tileentity.BlenderRenderer;
import com.mrcrayfish.furniture.render.tileentity.CeilingFanRenderer;
import com.mrcrayfish.furniture.render.tileentity.ChoppingBoardRenderer;
import com.mrcrayfish.furniture.render.tileentity.CoffeeTableRenderer;
import com.mrcrayfish.furniture.render.tileentity.CookieRenderer;
import com.mrcrayfish.furniture.render.tileentity.CupRenderer;
import com.mrcrayfish.furniture.render.tileentity.DigitalClockRenderer;
import com.mrcrayfish.furniture.render.tileentity.DoorMatRenderer;
import com.mrcrayfish.furniture.render.tileentity.EskyRenderer;
import com.mrcrayfish.furniture.render.tileentity.GrillRenderer;
import com.mrcrayfish.furniture.render.tileentity.MicrowaveRenderer;
import com.mrcrayfish.furniture.render.tileentity.MirrorRenderer;
import com.mrcrayfish.furniture.render.tileentity.ModernSlidingDoorRenderer;
import com.mrcrayfish.furniture.render.tileentity.OvenRenderer;
import com.mrcrayfish.furniture.render.tileentity.PhotoFrameRenderer;
import com.mrcrayfish.furniture.render.tileentity.PlateRenderer;
import com.mrcrayfish.furniture.render.tileentity.TVRenderer;
import com.mrcrayfish.furniture.render.tileentity.ToastRenderer;
import com.mrcrayfish.furniture.render.tileentity.TreeRenderer;
import com.mrcrayfish.furniture.render.tileentity.WashingMachineRenderer;
import com.mrcrayfish.furniture.tileentity.TileEntityBlender;
import com.mrcrayfish.furniture.tileentity.TileEntityCeilingFan;
import com.mrcrayfish.furniture.tileentity.TileEntityChoppingBoard;
import com.mrcrayfish.furniture.tileentity.TileEntityCoffeeTable;
import com.mrcrayfish.furniture.tileentity.TileEntityCookieJar;
import com.mrcrayfish.furniture.tileentity.TileEntityCup;
import com.mrcrayfish.furniture.tileentity.TileEntityDigitalClock;
import com.mrcrayfish.furniture.tileentity.TileEntityDoorMat;
import com.mrcrayfish.furniture.tileentity.TileEntityEsky;
import com.mrcrayfish.furniture.tileentity.TileEntityGrill;
import com.mrcrayfish.furniture.tileentity.TileEntityMicrowave;
import com.mrcrayfish.furniture.tileentity.TileEntityMirror;
import com.mrcrayfish.furniture.tileentity.TileEntityModernSlidingDoor;
import com.mrcrayfish.furniture.tileentity.TileEntityOven;
import com.mrcrayfish.furniture.tileentity.TileEntityPhotoFrame;
import com.mrcrayfish.furniture.tileentity.TileEntityPlate;
import com.mrcrayfish.furniture.tileentity.TileEntityTV;
import com.mrcrayfish.furniture.tileentity.TileEntityToaster;
import com.mrcrayfish.furniture.tileentity.TileEntityTree;
import com.mrcrayfish.furniture.tileentity.TileEntityWashingMachine;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    public static boolean rendering = false;
    public static Entity renderEntity = null;
    public static Entity backupEntity = null;

    @Override
    public void init() {
        this.registerColorHandlers();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCookieJar.class, (TileEntitySpecialRenderer)new CookieRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPlate.class, (TileEntitySpecialRenderer)new PlateRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityToaster.class, (TileEntitySpecialRenderer)new ToastRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityChoppingBoard.class, (TileEntitySpecialRenderer)new ChoppingBoardRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlender.class, (TileEntitySpecialRenderer)new BlenderRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMicrowave.class, (TileEntitySpecialRenderer)new MicrowaveRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWashingMachine.class, (TileEntitySpecialRenderer)new WashingMachineRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCup.class, (TileEntitySpecialRenderer)new CupRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTree.class, (TileEntitySpecialRenderer)new TreeRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMirror.class, (TileEntitySpecialRenderer)new MirrorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityOven.class, (TileEntitySpecialRenderer)new OvenRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGrill.class, (TileEntitySpecialRenderer)new GrillRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEsky.class, (TileEntitySpecialRenderer)new EskyRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDoorMat.class, (TileEntitySpecialRenderer)new DoorMatRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCeilingFan.class, (TileEntitySpecialRenderer)new CeilingFanRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityModernSlidingDoor.class, (TileEntitySpecialRenderer)new ModernSlidingDoorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDigitalClock.class, (TileEntitySpecialRenderer)new DigitalClockRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTV.class, (TileEntitySpecialRenderer)new TVRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCoffeeTable.class, (TileEntitySpecialRenderer)new CoffeeTableRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPhotoFrame.class, (TileEntitySpecialRenderer)new PhotoFrameRenderer());
        MinecraftForge.EVENT_BUS.register((Object)GifCache.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new MirrorRenderer());
    }

    public void registerColorHandlers() {
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a((stack, tintIndex) -> {
            if (tintIndex == 1 && stack.func_77942_o() && stack.func_77978_p().func_74764_b("Colour")) {
                int[] colour = stack.func_77978_p().func_74759_k("Colour");
                Color color = new Color(colour[0], colour[1], colour[2]);
                return color.getRGB();
            }
            return 0xFFFFFF;
        }, new Item[]{FurnitureItems.DRINK});
        IItemColor hedgeItemColor = (stack, tintIndex) -> {
            IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return Minecraft.func_71410_x().func_184125_al().func_186724_a(iblockstate, null, null, tintIndex);
        };
        IBlockColor hedgeBlockColorOld = (state, worldIn, pos, tintIndex) -> {
            Block block = state.func_177230_c();
            if (block == FurnitureBlocks.HEDGE_SPRUCE) {
                return ColorizerFoliage.func_77466_a();
            }
            if (block == FurnitureBlocks.HEDGE_BIRCH) {
                return ColorizerFoliage.func_77469_b();
            }
            return worldIn != null && pos != null ? BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerFoliage.func_77468_c();
        };
        IBlockColor hedgeBlockColorNew = (state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerFoliage.func_77468_c();
        this.registerColorHandlerForBlock(FurnitureBlocks.HEDGE_OAK, hedgeBlockColorOld, hedgeItemColor);
        this.registerColorHandlerForBlock(FurnitureBlocks.HEDGE_SPRUCE, hedgeBlockColorOld, hedgeItemColor);
        this.registerColorHandlerForBlock(FurnitureBlocks.HEDGE_BIRCH, hedgeBlockColorOld, hedgeItemColor);
        this.registerColorHandlerForBlock(FurnitureBlocks.HEDGE_JUNGLE, hedgeBlockColorOld, hedgeItemColor);
        this.registerColorHandlerForBlock(FurnitureBlocks.HEDGE_ACACIA, hedgeBlockColorNew, hedgeItemColor);
        this.registerColorHandlerForBlock(FurnitureBlocks.HEDGE_DARK_OAK, hedgeBlockColorNew, hedgeItemColor);
        IItemColor christmasItemColor = (stack, tintIndex) -> ColorizerFoliage.func_77466_a();
        IBlockColor christmasBlockColor = (state, worldIn, pos, tintIndex) -> ColorizerFoliage.func_77466_a();
        this.registerColorHandlerForBlock(FurnitureBlocks.TREE_BOTTOM, christmasBlockColor, christmasItemColor);
        this.registerColorHandlerForBlock(FurnitureBlocks.TREE_TOP, christmasBlockColor, christmasItemColor);
        this.registerColorHandlerForBlock(FurnitureBlocks.WREATH, christmasBlockColor, christmasItemColor);
    }

    public void registerColorHandlerForBlock(Block block, IBlockColor blockColor, IItemColor itemColor) {
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a(itemColor, new Item[]{Item.func_150898_a((Block)block)});
        FMLClientHandler.instance().getClient().func_184125_al().func_186722_a(blockColor, new Block[]{block});
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public boolean isSinglePlayer() {
        return Minecraft.func_71410_x().func_71356_B();
    }

    @Override
    public boolean isDedicatedServer() {
        return false;
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new InputHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GuiDrawHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
    }

    @SubscribeEvent
    public void onClientWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof WorldClient) {
            MirrorRenderer.mirrorGlobalRenderer.func_72732_a((WorldClient)event.getWorld());
        }
    }

    @SubscribeEvent
    public void onClientWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof WorldClient) {
            MirrorRenderer.clearRegisteredMirrors();
        }
    }

    @SubscribeEvent
    public void onPrePlayerRender(RenderPlayerEvent.Pre event) {
        if (!rendering) {
            return;
        }
        if (event.getEntityPlayer() == renderEntity) {
            backupEntity = Minecraft.func_71410_x().func_175598_ae().field_78734_h;
            Minecraft.func_71410_x().func_175598_ae().field_78734_h = renderEntity;
        }
    }

    @SubscribeEvent
    public void onPostPlayerRender(RenderPlayerEvent.Post event) {
        if (!rendering) {
            return;
        }
        if (event.getEntityPlayer() == renderEntity) {
            Minecraft.func_71410_x().func_175598_ae().field_78734_h = backupEntity;
            renderEntity = null;
        }
    }
}

