/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.BlockDummy;
import logisticspipes.blocks.LogisticsProgramCompilerTileEntity;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.blocks.crafting.LogisticsCraftingTableTileEntity;
import logisticspipes.blocks.powertile.LogisticsIC2PowerProviderTileEntity;
import logisticspipes.blocks.powertile.LogisticsPowerJunctionTileEntity;
import logisticspipes.blocks.powertile.LogisticsRFPowerProviderTileEntity;
import logisticspipes.blocks.stats.LogisticsStatisticsTileEntity;
import logisticspipes.interfaces.IGuiTileEntity;
import logisticspipes.interfaces.IRotationProvider;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LogisticsSolidBlock
extends Block {
    public static final PropertyInteger rotationProperty = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)3);
    public static final PropertyBool active = PropertyBool.func_177716_a((String)"active");
    public static final Map<EnumFacing, PropertyBool> connectionPropertys = Arrays.stream(EnumFacing.values()).collect(Collectors.toMap(key -> key, key -> PropertyBool.func_177716_a((String)("connection_" + key.ordinal()))));
    private final Type type;

    public LogisticsSolidBlock(Type type) {
        super(Material.field_151573_f);
        this.type = type;
        this.func_149711_c(6.0f);
        this.func_149647_a(LogisticsPipes.CREATIVE_TAB_LP);
        BlockDummy.updateBlockMap.put(type.getMeta(), this);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neigbour) {
        super.onNeighborChange(world, pos, neigbour);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof LogisticsSolidTileEntity) {
            ((LogisticsSolidTileEntity)tile).notifyOfBlockChange();
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!playerIn.func_70093_af() && (tile = worldIn.func_175625_s(pos)) instanceof IGuiTileEntity) {
            if (MainProxy.isServer((IBlockAccess)playerIn.field_70170_p)) {
                ((IGuiTileEntity)tile).getGuiProvider().setTilePos(tile).open(playerIn);
            }
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof LogisticsCraftingTableTileEntity) {
            ((LogisticsCraftingTableTileEntity)tile).placedBy(placer);
        }
        if (tile instanceof IRotationProvider) {
            ((IRotationProvider)tile).setFacing(placer.func_174811_aO().func_176734_d());
        }
    }

    public void func_180663_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof LogisticsSolidTileEntity) {
            ((LogisticsSolidTileEntity)tile).onBlockBreak();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        if (!this.type.hasTE()) {
            return null;
        }
        return this.type.createTE();
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.type.hasTE();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{rotationProperty}).add(new IProperty[]{active}).add(connectionPropertys.values().toArray(new IProperty[0])).build();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = super.func_176221_a(state, worldIn, pos);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof LogisticsSolidTileEntity) {
            LogisticsSolidTileEntity ste = (LogisticsSolidTileEntity)tile;
            int rotation = ste.getRotation();
            state = state.func_177226_a((IProperty)rotationProperty, (Comparable)Integer.valueOf(Math.min(Math.max(rotation, 0), 3))).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(ste.isActive()));
        }
        if (tile != null) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                boolean render = true;
                TileEntity sideTile = worldIn.func_175625_s(pos.func_177972_a(side));
                if (sideTile instanceof LogisticsTileGenericPipe) {
                    LogisticsTileGenericPipe tilePipe = (LogisticsTileGenericPipe)sideTile;
                    if (tilePipe.renderState.pipeConnectionMatrix.isConnected(side.func_176734_d())) {
                        render = false;
                    }
                }
                state = state.func_177226_a((IProperty)connectionPropertys.get(side), (Comparable)Boolean.valueOf(render));
            }
        }
        return state;
    }

    public Type getType() {
        return this.type;
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type LOGISTICS_POWER_JUNCTION = new Type(1, LogisticsPowerJunctionTileEntity::new);
        public static final /* enum */ Type LOGISTICS_SECURITY_STATION = new Type(2, LogisticsSecurityTileEntity::new);
        public static final /* enum */ Type LOGISTICS_AUTOCRAFTING_TABLE = new Type(3, LogisticsCraftingTableTileEntity::new);
        public static final /* enum */ Type LOGISTICS_FUZZYCRAFTING_TABLE = new Type(4, LogisticsCraftingTableTileEntity::new);
        public static final /* enum */ Type LOGISTICS_STATISTICS_TABLE = new Type(5, LogisticsStatisticsTileEntity::new);
        public static final /* enum */ Type LOGISTICS_RF_POWERPROVIDER = new Type(10, LogisticsRFPowerProviderTileEntity::new);
        public static final /* enum */ Type LOGISTICS_IC2_POWERPROVIDER = new Type(11, LogisticsIC2PowerProviderTileEntity::new);
        public static final /* enum */ Type LOGISTICS_BC_POWERPROVIDER = new Type(12);
        public static final /* enum */ Type LOGISTICS_PROGRAM_COMPILER = new Type(14, LogisticsProgramCompilerTileEntity::new);
        public static final /* enum */ Type LOGISTICS_BLOCK_FRAME = new Type(15);
        int meta;
        boolean hasActiveTexture;
        @Nullable
        private final Supplier<TileEntity> teConstructor;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int meta) {
            this(meta, null, false);
        }

        private Type(int meta, Supplier<TileEntity> teConstructor) {
            this(meta, teConstructor, false);
        }

        private Type(int meta, Supplier<TileEntity> teConstructor, boolean hasActiveTexture) {
            this.meta = meta;
            this.teConstructor = teConstructor;
            this.hasActiveTexture = hasActiveTexture;
        }

        public boolean hasTE() {
            return this.teConstructor != null;
        }

        public TileEntity createTE() {
            if (!this.hasTE()) {
                throw new UnsupportedOperationException("This block type has no tile entity!");
            }
            assert (this.teConstructor != null);
            return this.teConstructor.get();
        }

        public int getMeta() {
            return this.meta;
        }

        public boolean isHasActiveTexture() {
            return this.hasActiveTexture;
        }

        static {
            $VALUES = new Type[]{LOGISTICS_POWER_JUNCTION, LOGISTICS_SECURITY_STATION, LOGISTICS_AUTOCRAFTING_TABLE, LOGISTICS_FUZZYCRAFTING_TABLE, LOGISTICS_STATISTICS_TABLE, LOGISTICS_RF_POWERPROVIDER, LOGISTICS_IC2_POWERPROVIDER, LOGISTICS_BC_POWERPROVIDER, LOGISTICS_PROGRAM_COMPILER, LOGISTICS_BLOCK_FRAME};
        }
    }
}

