/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.powertile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.blocks.powertile.LogisticsPowerProviderTileEntity;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.cofh.subproxies.ICoFHEnergyStorage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class LogisticsRFPowerProviderTileEntity
extends LogisticsPowerProviderTileEntity {
    public static final int MAX_STORAGE = 10000000;
    public static final int MAX_MAXMODE = 8;
    public static final int MAX_PROVIDE_PER_TICK = 10000;
    private IEnergyStorage energyInterface = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return LogisticsRFPowerProviderTileEntity.this.storage.receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return LogisticsRFPowerProviderTileEntity.this.storage.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return LogisticsRFPowerProviderTileEntity.this.storage.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    };
    private ICoFHEnergyStorage storage = SimpleServiceLocator.powerProxy.getEnergyStorage(10000);

    public void addEnergy(double amount) {
        if (MainProxy.isClient((IBlockAccess)this.func_145831_w())) {
            return;
        }
        this.internalStorage += amount;
        if (this.internalStorage > 1.0E7) {
            this.internalStorage = 1.0E7;
        }
        if (this.internalStorage >= (double)this.getMaxStorage()) {
            this.needMorePowerTriggerCheck = false;
        }
    }

    private void addStoredRF() {
        int space = this.freeSpace();
        int available = this.storage.extractEnergy(space, true);
        if (available > 0 && this.storage.extractEnergy(available, false) == available) {
            this.addEnergy(available);
        }
    }

    public int freeSpace() {
        return (int)((double)this.getMaxStorage() - this.internalStorage);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (MainProxy.isServer((IBlockAccess)this.field_145850_b) && this.freeSpace() > 0) {
            this.addStoredRF();
        }
    }

    @Override
    public int getMaxStorage() {
        this.maxMode = Math.min(8, Math.max(1, this.maxMode));
        return 10000000 / this.maxMode;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        this.storage.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public String getBrand() {
        return "RF";
    }

    @Override
    protected double getMaxProvidePerTick() {
        return 10000.0;
    }

    @Override
    protected void handlePower(CoreRoutedPipe pipe, double toSend) {
        pipe.handleRFPowerArival(toSend);
    }

    @Override
    protected int getLaserColor() {
        return 0xFF0000;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyInterface;
        }
        return (T)super.getCapability(capability, facing);
    }
}

