/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.popup;

import java.io.IOException;
import java.util.List;
import logisticspipes.gui.popup.ActionChoisePopup;
import logisticspipes.interfaces.IGUIChannelInformationReceiver;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.DeleteChannelPacket;
import logisticspipes.network.packets.gui.OpenAddChannelGUIPacket;
import logisticspipes.network.packets.gui.OpenEditChannelGUIPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.channels.ChannelInformation;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.gui.SubGuiScreen;
import logisticspipes.utils.gui.TextListDisplay;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.input.Mouse;

public class GuiManageChannelPopup
extends SubGuiScreen
implements IGUIChannelInformationReceiver {
    private static String GUI_LANG_KEY = "gui.popup.managechannel.";
    protected final List<ChannelInformation> channelList;
    protected final TextListDisplay textList;
    private BlockPos position;

    public GuiManageChannelPopup(final List<ChannelInformation> channelList, BlockPos pos) {
        super(150, 170, 0, 0);
        this.channelList = channelList;
        this.position = pos;
        this.textList = new TextListDisplay(this, 6, 16, 6, 30, 12, new TextListDisplay.List(){

            @Override
            public int getSize() {
                return channelList.size();
            }

            @Override
            public String getTextAt(int index) {
                return ((ChannelInformation)channelList.get(index)).getName();
            }

            @Override
            public int getTextColor(int index) {
                return 0xFFFFFF;
            }
        });
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new SmallGuiButton(10, this.xCenter + 16, this.bottom - 27, 50, 10, "Delete"));
        this.field_146292_n.add(new SmallGuiButton(1, this.xCenter + 16, this.bottom - 15, 50, 10, "Exit"));
        this.field_146292_n.add(new SmallGuiButton(2, this.xCenter - 66, this.bottom - 27, 50, 10, "Add"));
        this.field_146292_n.add(new SmallGuiButton(3, this.xCenter - 66, this.bottom - 15, 50, 10, "Edit"));
        this.field_146292_n.add(new SmallGuiButton(4, this.xCenter - 12, this.bottom - 27, 25, 10, "/\\"));
        this.field_146292_n.add(new SmallGuiButton(5, this.xCenter - 12, this.bottom - 15, 25, 10, "\\/"));
    }

    @Override
    protected void renderGuiBackground(int mouseX, int mouseY) {
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.guiLeft, this.guiTop, this.right, this.bottom, this.field_73735_i, true);
        this.drawTitle();
        this.textList.renderGuiBackground(mouseX, mouseY);
    }

    protected void drawTitle() {
        this.field_146297_k.field_71466_p.func_175063_a(StringUtils.translate(GUI_LANG_KEY + "title"), (float)this.xCenter - (float)this.field_146297_k.field_71466_p.func_78256_a(StringUtils.translate(GUI_LANG_KEY + "title")) / 2.0f, (float)(this.guiTop + 6), 0xFFFFFF);
    }

    protected void func_73864_a(int i, int j, int k) throws IOException {
        this.textList.mouseClicked(i, j, k);
        super.func_73864_a(i, j, k);
    }

    @Override
    public void handleMouseInputSub() throws IOException {
        int wheel = Mouse.getDWheel() / 120;
        if (wheel == 0) {
            super.handleMouseInputSub();
        }
        if (wheel < 0) {
            this.textList.scrollUp();
        } else if (wheel > 0) {
            this.textList.scrollDown();
        }
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        if (guibutton.field_146127_k == 1) {
            this.exitGui();
        } else if (guibutton.field_146127_k == 2) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(OpenAddChannelGUIPacket.class).setBlockPos(this.position));
        } else if (guibutton.field_146127_k == 3) {
            int selected = this.textList.getSelected();
            if (selected >= 0) {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(OpenEditChannelGUIPacket.class).setIdentifier(this.channelList.get(selected).getChannelIdentifier().toString()).setBlockPos(this.position));
            }
        } else if (guibutton.field_146127_k == 4) {
            this.textList.scrollDown();
        } else if (guibutton.field_146127_k == 5) {
            this.textList.scrollUp();
        } else if (guibutton.field_146127_k == 10) {
            int selected = this.textList.getSelected();
            if (selected >= 0) {
                this.setSubGui(new ActionChoisePopup(StringUtils.translate(GUI_LANG_KEY + "deletedialog.title"), StringUtils.translate(GUI_LANG_KEY + "deletedialog.yes"), () -> MainProxy.sendPacketToServer(PacketHandler.getPacket(DeleteChannelPacket.class).setChannelIdentifier(this.channelList.get(selected).getChannelIdentifier())), StringUtils.translate(GUI_LANG_KEY + "deletedialog.no"), () -> {}));
            }
        } else {
            super.func_146284_a(guibutton);
        }
    }

    @Override
    public void handleChannelInformation(ChannelInformation channel, boolean flag) {
        if (!flag) {
            if (channel.getName() == null) {
                this.channelList.removeIf(chan -> chan.getChannelIdentifier().equals(channel.getChannelIdentifier()));
            } else if (this.channelList.stream().anyMatch(chan -> chan.getChannelIdentifier().equals(channel.getChannelIdentifier()))) {
                this.channelList.stream().filter(chan -> chan.getChannelIdentifier().equals(channel.getChannelIdentifier())).forEach(chan -> {
                    chan.setName(channel.getName());
                    chan.setRights(channel.getRights());
                    chan.setResponsibleSecurityID(channel.getResponsibleSecurityID());
                });
            } else {
                this.channelList.add(channel);
            }
        }
    }
}

