/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logisticspipes;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.ITrackStatistics;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.world.WorldCoordinatesWrapper;

public class PipeTransportLayer
extends TransportLayer {
    private final CoreRoutedPipe routedPipe;
    private final ITrackStatistics _trackStatistics;
    @Nonnull
    private final IRouter _router;

    public PipeTransportLayer(CoreRoutedPipe routedPipe, ITrackStatistics trackStatistics, @Nonnull IRouter router) {
        this.routedPipe = routedPipe;
        this._trackStatistics = trackStatistics;
        this._router = router;
    }

    @Override
    public EnumFacing itemArrived(IRoutedItem item, EnumFacing denyed) {
        CoreRoutedPipe pipe;
        if (item.getItemIdentifierStack() != null) {
            this._trackStatistics.recievedItem(item.getItemIdentifierStack().getStackSize());
        }
        List adjacentEntities = new WorldCoordinatesWrapper(this.routedPipe.container).connectedTileEntities(IPipeInformationProvider.ConnectionPipeType.ITEM).collect(Collectors.toList());
        LinkedList<EnumFacing> possibleEnumFacing = new LinkedList<EnumFacing>();
        for (NeighborTileEntity adjacent : adjacentEntities) {
            if (SimpleServiceLocator.pipeInformationManager.isItemPipe((TileEntity)adjacent.getTileEntity()) || this._router.isRoutedExit(adjacent.getDirection()) || denyed != null && denyed.equals((Object)adjacent.getDirection()) || (pipe = this._router.getPipe()) != null && pipe.isLockedExit(adjacent.getDirection())) continue;
            possibleEnumFacing.add(adjacent.getDirection());
        }
        if (possibleEnumFacing.size() != 0) {
            return (EnumFacing)possibleEnumFacing.get(this.routedPipe.getWorld().field_73012_v.nextInt(possibleEnumFacing.size()));
        }
        for (NeighborTileEntity adjacent : adjacentEntities) {
            if (this._router.isRoutedExit(adjacent.getDirection()) || (pipe = this._router.getPipe()) != null && pipe.isLockedExit(adjacent.getDirection())) continue;
            possibleEnumFacing.add(adjacent.getDirection());
        }
        if (possibleEnumFacing.size() == 0) {
            return null;
        }
        return (EnumFacing)possibleEnumFacing.get(this.routedPipe.getWorld().field_73012_v.nextInt(possibleEnumFacing.size()));
    }

    @Override
    public boolean stillWantItem(IRoutedItem item) {
        return true;
    }
}

