/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.guis.module.inpipe;

import java.util.BitSet;
import logisticspipes.gui.modules.GuiItemSink;
import logisticspipes.modules.ModuleItemSink;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.guis.module.inpipe.SimpleFilterInventorySlot;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.gui.DummyContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class ItemSinkSlot
extends ModuleCoordinatesGuiProvider {
    private boolean isDefaultRoute;
    private boolean hasFuzzyUpgrade;
    private BitSet ignoreData;
    private BitSet ignoreNBT;

    public ItemSinkSlot(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeBoolean(this.isDefaultRoute);
        output.writeBoolean(this.hasFuzzyUpgrade);
        output.writeBitSet(this.ignoreData);
        output.writeBitSet(this.ignoreNBT);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.isDefaultRoute = input.readBoolean();
        this.hasFuzzyUpgrade = input.readBoolean();
        this.ignoreData = input.readBitSet();
        this.ignoreNBT = input.readBitSet();
    }

    @Override
    public Object getClientGui(EntityPlayer player) {
        ModuleItemSink module = this.getLogisticsModule(player.func_130014_f_(), ModuleItemSink.class);
        if (module == null) {
            return null;
        }
        module.setDefaultRoute(this.isDefaultRoute);
        module.setIgnoreData(this.ignoreData);
        module.setIgnoreNBT(this.ignoreNBT);
        return new GuiItemSink((IInventory)player.field_71071_by, module, this.hasFuzzyUpgrade);
    }

    @Override
    public DummyContainer getContainer(EntityPlayer player) {
        return SimpleFilterInventorySlot.getContainerFromFilterModule(this, player);
    }

    @Override
    public GuiProvider template() {
        return new ItemSinkSlot(this.getId());
    }

    public boolean isDefaultRoute() {
        return this.isDefaultRoute;
    }

    public ItemSinkSlot setDefaultRoute(boolean isDefaultRoute) {
        this.isDefaultRoute = isDefaultRoute;
        return this;
    }

    public boolean isHasFuzzyUpgrade() {
        return this.hasFuzzyUpgrade;
    }

    public ItemSinkSlot setHasFuzzyUpgrade(boolean hasFuzzyUpgrade) {
        this.hasFuzzyUpgrade = hasFuzzyUpgrade;
        return this;
    }

    public BitSet getIgnoreData() {
        return this.ignoreData;
    }

    public ItemSinkSlot setIgnoreData(BitSet ignoreData) {
        this.ignoreData = ignoreData;
        return this;
    }

    public BitSet getIgnoreNBT() {
        return this.ignoreNBT;
    }

    public ItemSinkSlot setIgnoreNBT(BitSet ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
        return this;
    }
}

