/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.chassis;

import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class ChassisGUI
extends CoordinatesPacket {
    private int buttonID;

    public ChassisGUI(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeInt(this.buttonID);
        super.writeData(output);
    }

    @Override
    public void readData(LPDataInput input) {
        this.buttonID = input.readInt();
        super.readData(input);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe pipe = this.getPipe(player.field_70170_p);
        if (pipe == null || !(pipe.pipe instanceof PipeLogisticsChassi)) {
            return;
        }
        PipeLogisticsChassi chassisPipe = (PipeLogisticsChassi)pipe.pipe;
        LogisticsModule subModule = chassisPipe.getSubModule(this.getButtonID());
        if (!(subModule instanceof Gui)) {
            return;
        }
        Gui.getPipeGuiProvider((Gui)((Object)subModule)).setPosX(this.getPosX()).setPosY(this.getPosY()).setPosZ(this.getPosZ()).open(player);
    }

    @Override
    public ModernPacket template() {
        return new ChassisGUI(this.getId());
    }

    public int getButtonID() {
        return this.buttonID;
    }

    public ChassisGUI setButtonID(int buttonID) {
        this.buttonID = buttonID;
        return this;
    }
}

