/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.modules;

import java.util.BitSet;
import logisticspipes.modules.ModuleItemSink;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class ItemSinkFuzzy
extends ModuleCoordinatesPacket {
    private BitSet ignoreData;
    private BitSet ignoreNBT;
    private int pos = -1;
    private boolean isNBT = false;

    public ItemSinkFuzzy(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        ModuleItemSink module = this.getLogisticsModule(player, ModuleItemSink.class);
        if (module == null) {
            return;
        }
        if (this.pos != -1) {
            if (this.isNBT) {
                module.setIgnoreNBT(this.pos, player);
            } else {
                module.setIgnoreData(this.pos, player);
            }
        } else {
            module.setIgnoreNBT(this.ignoreNBT);
            module.setIgnoreData(this.ignoreData);
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeInt(this.pos);
        if (this.pos != -1) {
            output.writeBoolean(this.isNBT);
        } else {
            output.writeBitSet(this.ignoreData);
            output.writeBitSet(this.ignoreNBT);
        }
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.pos = input.readInt();
        if (this.pos != -1) {
            this.isNBT = input.readBoolean();
        } else {
            this.ignoreData = input.readBitSet();
            this.ignoreNBT = input.readBitSet();
        }
    }

    @Override
    public ModernPacket template() {
        return new ItemSinkFuzzy(this.getId());
    }

    public BitSet getIgnoreData() {
        return this.ignoreData;
    }

    public ItemSinkFuzzy setIgnoreData(BitSet ignoreData) {
        this.ignoreData = ignoreData;
        return this;
    }

    public BitSet getIgnoreNBT() {
        return this.ignoreNBT;
    }

    public ItemSinkFuzzy setIgnoreNBT(BitSet ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
        return this;
    }

    public int getPos() {
        return this.pos;
    }

    public ItemSinkFuzzy setPos(int pos) {
        this.pos = pos;
        return this;
    }

    public boolean isNBT() {
        return this.isNBT;
    }

    public ItemSinkFuzzy setNBT(boolean isNBT) {
        this.isNBT = isNBT;
        return this;
    }
}

