/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import logisticspipes.network.abstractpackets.Integer2CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.signs.IPipeSign;
import logisticspipes.pipes.signs.ItemAmountPipeSign;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class ItemAmountSignUpdatePacket
extends Integer2CoordinatesPacket {
    private ItemIdentifierStack stack = null;

    public ItemAmountSignUpdatePacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe pipe = this.getPipe(player.func_130014_f_());
        if (pipe == null || !pipe.isInitialized()) {
            return;
        }
        IPipeSign sign = ((CoreRoutedPipe)pipe.pipe).getPipeSign(EnumFacing.func_82600_a((int)this.getInteger()));
        if (sign == null) {
            return;
        }
        ((ItemAmountPipeSign)sign).amount = this.getInteger2();
        ((ItemAmountPipeSign)sign).itemTypeInv.setInventorySlotContents(0, this.stack);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        if (input.readBoolean()) {
            this.stack = input.readItemIdentifierStack();
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        if (this.stack == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            output.writeItemIdentifierStack(this.stack);
        }
    }

    @Override
    public ModernPacket template() {
        return new ItemAmountSignUpdatePacket(this.getId());
    }

    public ItemIdentifierStack getStack() {
        return this.stack;
    }

    public ItemAmountSignUpdatePacket setStack(ItemIdentifierStack stack) {
        this.stack = stack;
        return this;
    }
}

