/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.upgrade;

import java.util.Objects;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.SlotPacket;
import logisticspipes.pipes.upgrades.SneakyUpgradeConfig;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.gui.UpgradeSlot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class SneakyUpgradeSidePacket
extends SlotPacket {
    private EnumFacing side;

    public SneakyUpgradeSidePacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        UpgradeSlot slot = this.getSlot(player, UpgradeSlot.class);
        ItemStack stack = slot.func_75211_c();
        if (stack.func_190926_b()) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = Objects.requireNonNull(stack.func_77978_p());
        tag.func_74778_a("LPSNEAKY-SIDE", SneakyUpgradeConfig.Sides.getNameForDirection(this.side));
        slot.func_75215_d(stack);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeFacing(this.side);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.side = input.readFacing();
    }

    @Override
    public ModernPacket template() {
        return new SneakyUpgradeSidePacket(this.getId());
    }

    public SneakyUpgradeSidePacket setSide(EnumFacing side) {
        this.side = side;
        return this;
    }

    public EnumFacing getSide() {
        return this.side;
    }
}

