/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.upgrades;

import java.util.EnumSet;
import java.util.Objects;
import java.util.UUID;
import logisticspipes.LPItems;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IPipeUpgradeManager;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.items.ItemUpgrade;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.upgrades.ActionSpeedUpgrade;
import logisticspipes.pipes.upgrades.AdvancedSatelliteUpgrade;
import logisticspipes.pipes.upgrades.CCRemoteControlUpgrade;
import logisticspipes.pipes.upgrades.CombinedSneakyUpgrade;
import logisticspipes.pipes.upgrades.ConnectionUpgradeConfig;
import logisticspipes.pipes.upgrades.CraftingByproductUpgrade;
import logisticspipes.pipes.upgrades.CraftingCleanupUpgrade;
import logisticspipes.pipes.upgrades.CraftingMonitoringUpgrade;
import logisticspipes.pipes.upgrades.FluidCraftingUpgrade;
import logisticspipes.pipes.upgrades.FuzzyUpgrade;
import logisticspipes.pipes.upgrades.IConfigPipeUpgrade;
import logisticspipes.pipes.upgrades.IPipeUpgrade;
import logisticspipes.pipes.upgrades.ItemExtractionUpgrade;
import logisticspipes.pipes.upgrades.ItemStackExtractionUpgrade;
import logisticspipes.pipes.upgrades.LogicControllerUpgrade;
import logisticspipes.pipes.upgrades.OpaqueUpgrade;
import logisticspipes.pipes.upgrades.PatternUpgrade;
import logisticspipes.pipes.upgrades.PowerTransportationUpgrade;
import logisticspipes.pipes.upgrades.SneakyUpgradeConfig;
import logisticspipes.pipes.upgrades.SpeedUpgrade;
import logisticspipes.pipes.upgrades.UpgradeModuleUpgrade;
import logisticspipes.pipes.upgrades.power.BCPowerSupplierUpgrade;
import logisticspipes.pipes.upgrades.power.IC2PowerSupplierUpgrade;
import logisticspipes.pipes.upgrades.power.RFPowerSupplierUpgrade;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.SimpleStackInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class UpgradeManager
implements ISimpleInventoryEventHandler,
ISlotUpgradeManager,
IPipeUpgradeManager {
    private SimpleStackInventory inv = new SimpleStackInventory(9, "UpgradeInventory", 16);
    private SimpleStackInventory sneakyInv = new SimpleStackInventory(9, "SneakyUpgradeInventory", 1);
    private SimpleStackInventory secInv = new SimpleStackInventory(1, "SecurityInventory", 16);
    private IPipeUpgrade[] upgrades = new IPipeUpgrade[9];
    private IPipeUpgrade[] sneakyUpgrades = new IPipeUpgrade[9];
    private CoreRoutedPipe pipe;
    private int securityDelay = 0;
    private EnumFacing sneakyOrientation = null;
    private EnumFacing[] combinedSneakyOrientation = new EnumFacing[9];
    private int speedUpgradeCount = 0;
    private final EnumSet<EnumFacing> disconnectedSides = EnumSet.noneOf(EnumFacing.class);
    private boolean isAdvancedCrafter = false;
    private boolean isFuzzyUpgrade = false;
    private boolean isCombinedSneakyUpgrade = false;
    private int liquidCrafter = 0;
    private boolean hasByproductExtractor = false;
    private UUID uuid = null;
    private String uuidS = null;
    private boolean hasPatternUpgrade = false;
    private boolean hasPowerPassUpgrade = false;
    private boolean hasRFPowerUpgrade = false;
    private boolean hasBCPowerUpgrade = false;
    private int getIC2PowerLevel = 0;
    private boolean hasCCRemoteControlUpgrade = false;
    private boolean hasCraftingMonitoringUpgrade = false;
    private boolean hasOpaqueUpgrade = false;
    private int craftingCleanup = 0;
    private boolean hasLogicControll = false;
    private boolean hasUpgradeModuleUpgarde = false;
    private int actionSpeedUpgrade = 0;
    private int itemExtractionUpgrade = 0;
    private int itemStackExtractionUpgrade = 0;
    private boolean[] guiUpgrades = new boolean[18];
    private boolean needsContainerPositionUpdate = false;

    public UpgradeManager(CoreRoutedPipe pipe) {
        this.pipe = pipe;
        this.inv.addListener(this);
        this.sneakyInv.addListener(this);
        this.secInv.addListener(this);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.inv.readFromNBT(nbttagcompound, "UpgradeInventory_");
        this.sneakyInv.readFromNBT(nbttagcompound, "SneakyUpgradeInventory_");
        this.secInv.readFromNBT(nbttagcompound, "SecurityInventory_");
        if (!this.sneakyInv.func_70301_a(8).func_190926_b() && this.sneakyInv.func_70301_a(8).func_77973_b() == LPItems.itemCard && this.sneakyInv.func_70301_a(8).func_77952_i() == 1) {
            this.secInv.func_70299_a(0, this.sneakyInv.func_70301_a(8));
            this.sneakyInv.func_70299_a(8, ItemStack.field_190927_a);
        }
        this.InventoryChanged(this.inv);
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this.inv.writeToNBT(nbttagcompound, "UpgradeInventory_");
        this.sneakyInv.writeToNBT(nbttagcompound, "SneakyUpgradeInventory_");
        this.secInv.writeToNBT(nbttagcompound, "SecurityInventory_");
        this.InventoryChanged(this.inv);
    }

    private boolean updateModule(int slot, IPipeUpgrade[] upgrades, IInventory inv) {
        ItemStack stack = inv.func_70301_a(slot);
        upgrades[slot] = stack.func_77973_b() instanceof ItemUpgrade ? ((ItemUpgrade)stack.func_77973_b()).getUpgradeForItem(stack, upgrades[slot]) : null;
        if (upgrades[slot] == null) {
            inv.func_70299_a(slot, ItemStack.field_190927_a);
            return false;
        }
        return upgrades[slot].needsUpdate();
    }

    private boolean removeUpgrade(int slot, IPipeUpgrade[] upgrades) {
        boolean needUpdate = upgrades[slot].needsUpdate();
        upgrades[slot] = null;
        return needUpdate;
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        IPipeUpgrade upgrade;
        int i;
        boolean needUpdate = false;
        for (int i2 = 0; i2 < this.inv.func_70302_i_(); ++i2) {
            ItemStack item = this.inv.func_70301_a(i2);
            if (!item.func_190926_b()) {
                needUpdate |= this.updateModule(i2, this.upgrades, this.inv);
                continue;
            }
            if (this.upgrades[i2] == null) continue;
            needUpdate |= this.removeUpgrade(i2, this.upgrades);
        }
        this.sneakyOrientation = null;
        this.speedUpgradeCount = 0;
        this.isAdvancedCrafter = false;
        this.isFuzzyUpgrade = false;
        boolean combinedBuffer = this.isCombinedSneakyUpgrade;
        this.isCombinedSneakyUpgrade = false;
        this.liquidCrafter = 0;
        this.disconnectedSides.clear();
        this.hasByproductExtractor = false;
        this.hasPatternUpgrade = false;
        this.hasPowerPassUpgrade = false;
        this.hasRFPowerUpgrade = false;
        this.hasBCPowerUpgrade = false;
        this.getIC2PowerLevel = 0;
        this.hasCCRemoteControlUpgrade = false;
        this.hasCraftingMonitoringUpgrade = false;
        this.hasOpaqueUpgrade = false;
        this.craftingCleanup = 0;
        this.hasLogicControll = false;
        this.hasUpgradeModuleUpgarde = false;
        this.actionSpeedUpgrade = 0;
        this.itemExtractionUpgrade = 0;
        this.itemStackExtractionUpgrade = 0;
        this.guiUpgrades = new boolean[18];
        for (i = 0; i < this.upgrades.length; ++i) {
            upgrade = this.upgrades[i];
            if (upgrade instanceof SneakyUpgradeConfig && this.sneakyOrientation == null && !this.isCombinedSneakyUpgrade) {
                this.sneakyOrientation = ((SneakyUpgradeConfig)upgrade).getSide(this.getInv().func_70301_a(i));
            } else if (upgrade instanceof SpeedUpgrade) {
                this.speedUpgradeCount += this.inv.func_70301_a(i).func_190916_E();
            } else if (upgrade instanceof ConnectionUpgradeConfig) {
                ((ConnectionUpgradeConfig)upgrade).getSides(this.getInv().func_70301_a(i)).forEach(this.disconnectedSides::add);
            } else if (upgrade instanceof AdvancedSatelliteUpgrade) {
                this.isAdvancedCrafter = true;
            } else if (upgrade instanceof FuzzyUpgrade) {
                this.isFuzzyUpgrade = true;
            } else if (upgrade instanceof CombinedSneakyUpgrade && this.sneakyOrientation == null) {
                this.isCombinedSneakyUpgrade = true;
            } else if (upgrade instanceof FluidCraftingUpgrade) {
                this.liquidCrafter += this.inv.func_70301_a(i).func_190916_E();
            } else if (upgrade instanceof CraftingByproductUpgrade) {
                this.hasByproductExtractor = true;
            } else if (upgrade instanceof PatternUpgrade) {
                this.hasPatternUpgrade = true;
            } else if (upgrade instanceof PowerTransportationUpgrade) {
                this.hasPowerPassUpgrade = true;
            } else if (upgrade instanceof RFPowerSupplierUpgrade) {
                this.hasRFPowerUpgrade = true;
            } else if (upgrade instanceof BCPowerSupplierUpgrade) {
                this.hasBCPowerUpgrade = true;
            } else if (upgrade instanceof IC2PowerSupplierUpgrade) {
                this.getIC2PowerLevel = Math.max(this.getIC2PowerLevel, ((IC2PowerSupplierUpgrade)upgrade).getPowerLevel());
            } else if (upgrade instanceof CCRemoteControlUpgrade) {
                this.hasCCRemoteControlUpgrade = true;
            } else if (upgrade instanceof CraftingMonitoringUpgrade) {
                this.hasCraftingMonitoringUpgrade = true;
            } else if (upgrade instanceof OpaqueUpgrade) {
                this.hasOpaqueUpgrade = true;
            } else if (upgrade instanceof CraftingCleanupUpgrade) {
                this.craftingCleanup += this.inv.func_70301_a(i).func_190916_E();
            } else if (upgrade instanceof LogicControllerUpgrade) {
                this.hasLogicControll = true;
            } else if (upgrade instanceof UpgradeModuleUpgrade) {
                this.hasUpgradeModuleUpgarde = true;
            } else if (upgrade instanceof ActionSpeedUpgrade) {
                this.actionSpeedUpgrade += this.inv.func_70301_a(i).func_190916_E();
            } else if (upgrade instanceof ItemExtractionUpgrade) {
                this.itemExtractionUpgrade += this.inv.func_70301_a(i).func_190916_E();
            } else if (upgrade instanceof ItemStackExtractionUpgrade) {
                this.itemStackExtractionUpgrade += this.inv.func_70301_a(i).func_190916_E();
            }
            if (!(upgrade instanceof IConfigPipeUpgrade)) continue;
            this.guiUpgrades[i] = true;
        }
        this.liquidCrafter = Math.min(this.liquidCrafter, 3);
        this.craftingCleanup = Math.min(this.craftingCleanup, 4);
        this.itemExtractionUpgrade = Math.min(this.itemExtractionUpgrade, 8);
        this.itemStackExtractionUpgrade = Math.min(this.itemStackExtractionUpgrade, 8);
        if (combinedBuffer != this.isCombinedSneakyUpgrade) {
            this.needsContainerPositionUpdate = true;
        }
        for (i = 0; i < this.sneakyInv.func_70302_i_(); ++i) {
            ItemStack item = this.sneakyInv.func_70301_a(i);
            if (!item.func_190926_b()) {
                needUpdate |= this.updateModule(i, this.sneakyUpgrades, this.sneakyInv);
                continue;
            }
            if (this.sneakyUpgrades[i] == null) continue;
            needUpdate |= this.removeUpgrade(i, this.sneakyUpgrades);
        }
        for (i = 0; i < this.sneakyUpgrades.length; ++i) {
            upgrade = this.sneakyUpgrades[i];
            if (upgrade instanceof SneakyUpgradeConfig) {
                ItemStack stack = this.getSneakyInv().func_70301_a(i);
                this.combinedSneakyOrientation[i] = ((SneakyUpgradeConfig)upgrade).getSide(stack);
            }
            if (!(upgrade instanceof IConfigPipeUpgrade)) continue;
            this.guiUpgrades[i + 9] = true;
        }
        if (needUpdate) {
            this.pipe.connectionUpdate();
            if (this.pipe.container != null) {
                this.pipe.container.sendUpdateToClient();
            }
        }
        this.uuid = null;
        this.uuidS = null;
        ItemStack stack = this.secInv.func_70301_a(0);
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77973_b() != LPItems.itemCard || stack.func_77952_i() != 1) {
            return;
        }
        if (!stack.func_77942_o()) {
            return;
        }
        if (!stack.func_77978_p().func_74764_b("UUID")) {
            return;
        }
        this.uuid = UUID.fromString(stack.func_77978_p().func_74779_i("UUID"));
        this.uuidS = this.uuid.toString();
    }

    @Override
    public boolean hasSneakyUpgrade() {
        return this.sneakyOrientation != null;
    }

    @Override
    public EnumFacing getSneakyOrientation() {
        return this.sneakyOrientation;
    }

    @Override
    public int getSpeedUpgradeCount() {
        return this.speedUpgradeCount;
    }

    @Override
    public boolean hasCombinedSneakyUpgrade() {
        return this.isCombinedSneakyUpgrade;
    }

    @Override
    public EnumFacing[] getCombinedSneakyOrientation() {
        return this.combinedSneakyOrientation;
    }

    public IGuiOpenControler getGuiController() {
        return new IGuiOpenControler(){
            PlayerCollectionList players = new PlayerCollectionList();

            @Override
            public void guiOpenedByPlayer(EntityPlayer player) {
                this.players.add(player);
            }

            @Override
            public void guiClosedByPlayer(EntityPlayer player) {
                this.players.remove(player);
                if (this.players.isEmpty() && !UpgradeManager.this.isCombinedSneakyUpgrade) {
                    UpgradeManager.this.sneakyInv.dropContents(UpgradeManager.this.pipe.getWorld(), UpgradeManager.this.pipe.getPos());
                }
            }
        };
    }

    public boolean isNeedingContainerUpdate() {
        boolean tmp = this.needsContainerPositionUpdate;
        this.needsContainerPositionUpdate = false;
        return tmp;
    }

    public void dropUpgrades() {
        this.inv.dropContents(this.pipe.getWorld(), this.pipe.getPos());
        this.sneakyInv.dropContents(this.pipe.getWorld(), this.pipe.getPos());
    }

    @Override
    public boolean isSideDisconnected(EnumFacing side) {
        return this.disconnectedSides.contains(side);
    }

    public boolean tryIserting(World world, EntityPlayer entityplayer) {
        ItemStack itemStackInMainHand = entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND);
        if (!itemStackInMainHand.func_190926_b() && itemStackInMainHand.func_77973_b() instanceof ItemUpgrade) {
            if (MainProxy.isClient((IBlockAccess)world)) {
                return true;
            }
            IPipeUpgrade upgrade = ((ItemUpgrade)itemStackInMainHand.func_77973_b()).getUpgradeForItem(itemStackInMainHand, null);
            if (upgrade.isAllowedForPipe(this.pipe)) {
                if (this.isCombinedSneakyUpgrade && upgrade instanceof SneakyUpgradeConfig && this.insertIntInv(entityplayer, this.sneakyInv)) {
                    return true;
                }
                if (this.insertIntInv(entityplayer, this.inv)) {
                    return true;
                }
            }
        }
        if (!itemStackInMainHand.func_190926_b() && itemStackInMainHand.func_77973_b() == LPItems.itemCard && itemStackInMainHand.func_77952_i() == 1) {
            if (MainProxy.isClient((IBlockAccess)world)) {
                return true;
            }
            if (this.secInv.func_70301_a(0).func_190926_b()) {
                ItemStack newItem = itemStackInMainHand.func_77979_a(1);
                this.secInv.func_70299_a(0, newItem);
                this.InventoryChanged(this.secInv);
                return true;
            }
        }
        return false;
    }

    private boolean insertIntInv(EntityPlayer entityplayer, SimpleStackInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (item.func_190926_b()) {
                inv.func_70299_a(i, entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77979_a(1));
                this.InventoryChanged(inv);
                return true;
            }
            if (!ItemIdentifier.get(item).equals(ItemIdentifier.get(entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND))) || item.func_190916_E() >= inv.func_70297_j_()) continue;
            item.func_190917_f(1);
            entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77979_a(1);
            inv.func_70299_a(i, item);
            this.InventoryChanged(inv);
            return true;
        }
        return false;
    }

    public UUID getSecurityID() {
        return this.uuid;
    }

    public void insetSecurityID(UUID id) {
        ItemStack stack = new ItemStack((Item)LPItems.itemCard, 1, 1);
        stack.func_77982_d(new NBTTagCompound());
        NBTTagCompound tag = Objects.requireNonNull(stack.func_77978_p());
        tag.func_74778_a("UUID", id.toString());
        this.secInv.func_70299_a(0, stack);
        this.InventoryChanged(this.secInv);
    }

    public void securityTick() {
        if (this.getSecurityID() != null) {
            this.securityDelay = !SimpleServiceLocator.securityStationManager.isAuthorized(this.uuidS) ? ++this.securityDelay : 0;
            if (this.securityDelay > 20) {
                this.secInv.clearInventorySlotContents(0);
                this.InventoryChanged(this.secInv);
            }
        }
    }

    @Override
    public boolean isAdvancedSatelliteCrafter() {
        return this.isAdvancedCrafter;
    }

    @Override
    public boolean isFuzzyUpgrade() {
        return this.isFuzzyUpgrade;
    }

    @Override
    public int getFluidCrafter() {
        return this.liquidCrafter;
    }

    @Override
    public boolean hasByproductExtractor() {
        return this.hasByproductExtractor;
    }

    @Override
    public boolean hasPatternUpgrade() {
        return this.hasPatternUpgrade;
    }

    @Override
    public boolean hasPowerPassUpgrade() {
        return this.hasPowerPassUpgrade || this.hasRFPowerUpgrade || this.hasBCPowerUpgrade || this.getIC2PowerLevel > 0;
    }

    @Override
    public boolean hasRFPowerSupplierUpgrade() {
        return this.hasRFPowerUpgrade;
    }

    @Override
    public boolean hasBCPowerSupplierUpgrade() {
        return this.hasBCPowerUpgrade;
    }

    @Override
    public int getIC2PowerLevel() {
        return this.getIC2PowerLevel;
    }

    @Override
    public boolean hasCCRemoteControlUpgrade() {
        return this.hasCCRemoteControlUpgrade;
    }

    @Override
    public boolean hasCraftingMonitoringUpgrade() {
        return this.hasCraftingMonitoringUpgrade;
    }

    @Override
    public boolean isOpaque() {
        return this.hasOpaqueUpgrade;
    }

    @Override
    public int getCrafterCleanup() {
        return this.craftingCleanup;
    }

    public boolean hasLogicControll() {
        return this.hasLogicControll;
    }

    @Override
    public boolean hasUpgradeModuleUpgrade() {
        return this.hasUpgradeModuleUpgarde;
    }

    @Override
    public boolean hasOwnSneakyUpgrade() {
        return false;
    }

    public boolean hasGuiUpgrade(int i) {
        return this.guiUpgrades[i];
    }

    @Override
    public IPipeUpgrade getUpgrade(int i) {
        if (i < this.upgrades.length) {
            return this.upgrades[i];
        }
        return this.sneakyUpgrades[i - this.upgrades.length];
    }

    @Override
    public DoubleCoordinates getPipePosition() {
        return this.pipe.getLPPosition();
    }

    @Override
    public int getActionSpeedUpgrade() {
        return this.actionSpeedUpgrade;
    }

    @Override
    public int getItemExtractionUpgrade() {
        return this.itemExtractionUpgrade;
    }

    @Override
    public int getItemStackExtractionUpgrade() {
        return this.itemStackExtractionUpgrade;
    }

    @Override
    public SimpleStackInventory getInv() {
        return this.inv;
    }

    public SimpleStackInventory getSneakyInv() {
        return this.sneakyInv;
    }

    public SimpleStackInventory getSecInv() {
        return this.secInv;
    }
}

