/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import buildcraft.api.inventory.IItemTransactor;
import buildcraft.lib.misc.CapUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class BuildCraftTransactorHandler
extends SpecialInventoryHandler
implements SpecialInventoryHandler.Factory {
    private IItemTransactor cap = null;

    private BuildCraftTransactorHandler(IItemTransactor cap) {
        this.cap = cap;
    }

    public BuildCraftTransactorHandler() {
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(@Nonnull TileEntity tile, @Nullable EnumFacing dir) {
        return tile.hasCapability(CapUtil.CAP_ITEM_TRANSACTOR, dir);
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(@Nonnull TileEntity tile, @Nullable EnumFacing dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        IItemTransactor cap = (IItemTransactor)tile.getCapability(CapUtil.CAP_ITEM_TRANSACTOR, dir);
        if (cap != null) {
            return new BuildCraftTransactorHandler(cap);
        }
        return null;
    }

    @Override
    @Nonnull
    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        return Collections.emptyMap();
    }

    @Override
    @Nonnull
    public ItemStack getSingleItem(ItemIdentifier item) {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean containsUndamagedItem(@Nonnull ItemIdentifier item) {
        return false;
    }

    @Override
    public int roomForItem(@Nonnull ItemStack stack) {
        return stack.func_190916_E() - this.cap.insert(stack, false, true).func_190916_E();
    }

    @Override
    @Nonnull
    public Set<ItemIdentifier> getItems() {
        return Collections.emptySet();
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot != 0) {
            return ItemStack.field_190927_a;
        }
        return this.cap.extract(it -> true, 0, 64, true);
    }

    @Override
    @Nonnull
    public ItemStack decrStackSize(int slot, int amount) {
        if (slot != 0) {
            return ItemStack.field_190927_a;
        }
        return this.cap.extract(it -> true, amount, amount, false);
    }

    @Override
    @Nonnull
    public ItemStack add(@Nonnull ItemStack stack, EnumFacing orientation, boolean doAdd) {
        ItemStack overflow = this.cap.insert(stack.func_77946_l(), false, !doAdd);
        stack.func_190920_e(stack.func_190916_E() - overflow.func_190916_E());
        return stack;
    }
}

