/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.bs.ICrateStorageProxy;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class CrateInventoryHandler
extends SpecialInventoryHandler
implements SpecialInventoryHandler.Factory {
    private final ICrateStorageProxy _tile;
    private final boolean _hideOnePerStack;
    LinkedList<Map.Entry<ItemIdentifier, Integer>> cached;

    private CrateInventoryHandler(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._tile = SimpleServiceLocator.betterStorageProxy.getCrateStorageProxy(tile);
        this._hideOnePerStack = hideOnePerStack || hideOne;
    }

    public CrateInventoryHandler() {
        this._tile = null;
        this._hideOnePerStack = false;
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(@Nonnull TileEntity tile, @Nullable EnumFacing dir) {
        return SimpleServiceLocator.betterStorageProxy.isBetterStorageCrate(tile);
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(@Nonnull TileEntity tile, @Nullable EnumFacing dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new CrateInventoryHandler(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    @Nonnull
    public Set<ItemIdentifier> getItems() {
        TreeSet<ItemIdentifier> result2 = new TreeSet<ItemIdentifier>();
        for (ItemStack stack : this._tile.getContents()) {
            result2.add(ItemIdentifier.get(stack));
        }
        return result2;
    }

    @Override
    @Nonnull
    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        return this.getItemsAndCount(false);
    }

    private Map<ItemIdentifier, Integer> getItemsAndCount(boolean linked) {
        HashMap<ItemIdentifier, Integer> map2 = new HashMap<ItemIdentifier, Integer>((int)((double)this._tile.getUniqueItems() * 1.5));
        for (ItemStack stack : this._tile.getContents()) {
            ItemIdentifier itemId = ItemIdentifier.get(stack);
            int stackSize = stack.func_190916_E() - (this._hideOnePerStack ? 1 : 0);
            map2.merge(itemId, stackSize, Integer::sum);
        }
        return map2;
    }

    @Override
    @Nonnull
    public ItemStack getSingleItem(ItemIdentifier itemIdent) {
        int count2 = this._tile.getItemCount(itemIdent.unsafeMakeNormalStack(1));
        if (count2 <= (this._hideOnePerStack ? 1 : 0)) {
            return ItemStack.field_190927_a;
        }
        return this._tile.extractItems(itemIdent.makeNormalStack(1), 1);
    }

    @Override
    public boolean containsUndamagedItem(@Nonnull ItemIdentifier itemIdent) {
        if (!itemIdent.isDamageable()) {
            int count2 = this._tile.getItemCount(itemIdent.unsafeMakeNormalStack(1));
            return count2 > 0;
        }
        for (ItemStack stack : this._tile.getContents()) {
            ItemIdentifier itemId = ItemIdentifier.get(stack).getUndamaged();
            if (!itemId.equals(itemIdent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int roomForItem(@Nonnull ItemStack stack) {
        return this._tile.getSpaceForItem(stack);
    }

    @Override
    @Nonnull
    public ItemStack add(@Nonnull ItemStack stack, EnumFacing from, boolean doAdd) {
        ItemStack st = stack.func_77946_l();
        st.func_190920_e(0);
        if (doAdd) {
            ItemStack tst = stack.func_77946_l();
            ItemStack overflow = this._tile.insertItems(tst);
            st.func_190920_e(stack.func_190916_E());
            if (!overflow.func_190926_b()) {
                st.func_190918_g(overflow.func_190916_E());
            }
        } else {
            st.func_190920_e(Math.max(Math.min(this.roomForItem(stack), stack.func_190916_E()), 0));
        }
        return st;
    }

    @Override
    public int getSizeInventory() {
        if (this.cached == null) {
            this.initCache();
        }
        return this.cached.size();
    }

    public void initCache() {
        Map<ItemIdentifier, Integer> map2 = this.getItemsAndCount(true);
        this.cached = new LinkedList();
        this.cached.addAll(map2.entrySet());
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int i) {
        Map.Entry<ItemIdentifier, Integer> entry;
        if (this.cached == null) {
            this.initCache();
        }
        if ((entry = this.cached.get(i)).getValue() == 0) {
            return ItemStack.field_190927_a;
        }
        return entry.getKey().makeNormalStack(entry.getValue());
    }

    @Override
    @Nonnull
    public ItemStack decrStackSize(int i, int j) {
        Map.Entry<ItemIdentifier, Integer> entry;
        ItemStack stack;
        int count2;
        if (this.cached == null) {
            this.initCache();
        }
        if ((count2 = this._tile.getItemCount(stack = (entry = this.cached.get(i)).getKey().makeNormalStack(j))) <= (this._hideOnePerStack ? 1 : 0)) {
            return ItemStack.field_190927_a;
        }
        ItemStack extracted = this._tile.extractItems(stack, 1);
        entry.setValue(entry.getValue() - j);
        return extracted;
    }
}

