/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.channels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.interfaces.routing.IChannelManager;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.gui.ChannelInformationPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.channels.ChannelInformation;
import logisticspipes.security.SecuritySettings;
import logisticspipes.utils.PlayerIdentifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class ChannelManager
implements IChannelManager {
    private static final String DATA_NAME = "logisticspipes_ChannelManager_SavedData";
    private SavedData savedData;

    public ChannelManager(@Nonnull World world) {
        this.savedData = (SavedData)Objects.requireNonNull(world.func_175693_T()).func_75742_a(SavedData.class, DATA_NAME);
        if (this.savedData == null) {
            this.savedData = new SavedData();
            world.func_175693_T().func_75745_a(DATA_NAME, (WorldSavedData)this.savedData);
        }
    }

    @Override
    public List<ChannelInformation> getChannels() {
        return Collections.unmodifiableList(this.savedData.channels);
    }

    private boolean isChannelAllowedFor(ChannelInformation channel, EntityPlayer player) {
        switch (channel.getRights()) {
            case PUBLIC: {
                return true;
            }
            case SECURED: {
                UUID secUUID = channel.getResponsibleSecurityID();
                LogisticsSecurityTileEntity station = SimpleServiceLocator.securityStationManager.getStation(secUUID);
                SecuritySettings settings = station.getSecuritySettingsForPlayer(player, false);
                if (settings != null) {
                    return settings.accessRoutingChannels;
                }
            }
            case PRIVATE: {
                return channel.getOwner().equals(PlayerIdentifier.get(player));
            }
        }
        return false;
    }

    @Override
    public List<ChannelInformation> getAllowedChannels(EntityPlayer player) {
        return Collections.unmodifiableList(this.savedData.channels.stream().filter(channel -> this.isChannelAllowedFor((ChannelInformation)channel, player)).collect(Collectors.toList()));
    }

    @Override
    public ChannelInformation createNewChannel(String name, PlayerIdentifier owner, ChannelInformation.AccessRights rights, UUID responsibleSecurityID) {
        ChannelInformation channel = new ChannelInformation(name, UUID.randomUUID(), owner, rights, responsibleSecurityID);
        this.savedData.channels.add(channel);
        this.savedData.func_76185_a();
        this.sendUpdatePacketToClients(channel);
        return channel;
    }

    @Override
    public void updateChannelName(UUID channelIdentifier, String newName) {
        this.savedData.channels.stream().filter(channel -> channel.getChannelIdentifier().equals(channelIdentifier)).forEach(channel -> {
            channel.setName(newName);
            this.sendUpdatePacketToClients((ChannelInformation)channel);
        });
        this.savedData.func_76185_a();
    }

    @Override
    public void updateChannelRights(UUID channelIdentifier, ChannelInformation.AccessRights rights, UUID responsibleSecurityID) {
        this.savedData.channels.stream().filter(channel -> channel.getChannelIdentifier().equals(channelIdentifier)).forEach(channel -> {
            channel.setRights(rights);
            channel.setResponsibleSecurityID(responsibleSecurityID);
            this.sendUpdatePacketToClients((ChannelInformation)channel);
        });
        this.savedData.func_76185_a();
    }

    @Override
    public void removeChannel(UUID channelIdentifier) {
        Optional<ChannelInformation> optChannel = this.savedData.channels.stream().filter(channel -> channel.getChannelIdentifier().equals(channelIdentifier)).findFirst();
        this.savedData.channels.removeIf(channel -> channel.getChannelIdentifier().equals(channelIdentifier));
        optChannel.ifPresent(channelInformation -> this.sendUpdatePacketToClients(new ChannelInformation(null, channelIdentifier, channelInformation.getOwner(), channelInformation.getRights(), null)));
        this.savedData.func_76185_a();
    }

    public void markDirty() {
        this.savedData.func_76185_a();
    }

    private void sendUpdatePacketToClients(ChannelInformation channel) {
        MainProxy.sendToAllPlayers(PacketHandler.getPacket(ChannelInformationPacket.class).setInformation(channel).setTargeted(false).setCompressable(true));
    }

    public static class SavedData
    extends WorldSavedData {
        List<ChannelInformation> channels = new ArrayList<ChannelInformation>();

        public SavedData(String name) {
            super(name);
        }

        public SavedData() {
            this(ChannelManager.DATA_NAME);
        }

        public void func_76184_a(NBTTagCompound nbt) {
            this.channels = new ArrayList<ChannelInformation>();
            for (int i = 0; i < nbt.func_74762_e("dataSize"); ++i) {
                this.channels.add(i, new ChannelInformation(nbt.func_74775_l("data" + i)));
            }
        }

        @Nonnull
        public NBTTagCompound func_189551_b(NBTTagCompound compound) {
            compound.func_74768_a("dataSize", this.channels.size());
            for (int i = 0; i < this.channels.size(); ++i) {
                ChannelInformation channel = this.channels.get(i);
                NBTTagCompound nbt = new NBTTagCompound();
                channel.writeToNBT(nbt);
                compound.func_74782_a("data" + i, (NBTBase)nbt);
            }
            return compound;
        }

        public List<ChannelInformation> getChannels() {
            return this.channels;
        }

        public SavedData setChannels(List<ChannelInformation> channels) {
            this.channels = channels;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SavedData)) {
                return false;
            }
            SavedData other = (SavedData)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            List<ChannelInformation> this$channels = this.getChannels();
            List<ChannelInformation> other$channels = other.getChannels();
            return !(this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SavedData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            List<ChannelInformation> $channels = this.getChannels();
            result2 = result2 * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
            return result2;
        }

        public String toString() {
            return "ChannelManager.SavedData(channels=" + this.getChannels() + ")";
        }
    }
}

