/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraftforge.fluids.FluidStack;

public class FluidIdentifierStack
implements Comparable<FluidIdentifierStack> {
    private Object ccType;
    private final FluidIdentifier _fluid;
    private int amount;

    public FluidIdentifierStack(FluidIdentifier fluid, int stackSize) {
        this._fluid = fluid;
        this.setAmount(stackSize);
    }

    public static FluidIdentifierStack getFromStack(FluidStack stack) {
        FluidIdentifier fluid = FluidIdentifier.get(stack);
        if (fluid == null) {
            return null;
        }
        return new FluidIdentifierStack(fluid, stack.amount);
    }

    public static FluidIdentifierStack getFromStack(ItemIdentifierStack stack) {
        FluidIdentifier fluid = FluidIdentifier.get(stack);
        if (fluid == null) {
            return null;
        }
        return new FluidIdentifierStack(fluid, stack.getStackSize());
    }

    public FluidIdentifier getFluid() {
        return this._fluid;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int stackSize) {
        this.amount = stackSize;
    }

    public void lowerAmount(int stackSize) {
        this.amount -= stackSize;
    }

    public void raiseAmount(int stackSize) {
        this.amount += stackSize;
    }

    public FluidStack makeFluidStack() {
        return this._fluid.makeFluidStack(this.amount);
    }

    @Override
    public int compareTo(FluidIdentifierStack o) {
        int c = this._fluid.compareTo(o._fluid);
        if (c == 0) {
            return this.getAmount() - o.getAmount();
        }
        return c;
    }
}

