/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.grow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TickExecutor
extends AbstractExecutorService
implements ScheduledExecutorService {
    public static final long MILLISECONDS_PER_TICK = 50L;
    private final Thread tickingThread;
    private ConcurrentLinkedQueue<Runnable> taskQueue;
    private long currentTick;
    private long nextTask;
    private ReentrantLock schedulerLock;
    private LinkedList<TickScheduledTask<?>> scheduledTaskList;
    private CompletableFuture<Void> terminationFuture;
    private ReentrantReadWriteLock shutdownLock;
    private boolean shuttingDown;

    public TickExecutor(@Nullable Thread tickingThread) {
        this.tickingThread = tickingThread;
        this.taskQueue = new ConcurrentLinkedQueue();
        this.currentTick = 0L;
        this.nextTask = Long.MAX_VALUE;
        this.schedulerLock = new ReentrantLock();
        this.scheduledTaskList = new LinkedList();
        this.terminationFuture = new CompletableFuture();
        this.shutdownLock = new ReentrantReadWriteLock();
        this.shuttingDown = false;
    }

    public TickExecutor() {
        this(null);
    }

    private void checkShutDown() {
        if (this.shuttingDown || this.terminationFuture.isDone()) {
            throw new IllegalStateException("Executor is shut down");
        }
    }

    public <T> CompletableFuture<T> scheduleForCompletable(Supplier<T> supplier, long delay, TimeUnit unit) {
        CompletableFuture scheduledFuture = new CompletableFuture();
        this.schedule(() -> scheduledFuture.complete(null), delay, unit);
        return scheduledFuture.thenApply(Void2 -> supplier.get());
    }

    public <T> CompletableFuture<T> submitForCompletable(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(supplier, this);
    }

    public CompletableFuture<Void> submitForCompletable(Runnable runnable) {
        return CompletableFuture.runAsync(runnable, this);
    }

    private <V> void scheduleUnsafe(TickScheduledTask<V> task) {
        int taskTick = task.getExecutorScheduledTick();
        boolean added = false;
        for (int i = 0; i < this.scheduledTaskList.size(); ++i) {
            TickScheduledTask<?> other = this.scheduledTaskList.get(i);
            if (taskTick >= other.getExecutorScheduledTick()) continue;
            this.scheduledTaskList.add(i, task);
            added = true;
            break;
        }
        if ((long)taskTick < this.nextTask) {
            this.nextTask = taskTick;
        }
        if (!added) {
            this.scheduledTaskList.addLast(task);
        }
    }

    private <V> TickScheduledTask<V> schedule(TickScheduledTask<V> task) {
        this.schedulerLock.lock();
        try {
            this.scheduleUnsafe(task);
        }
        finally {
            this.schedulerLock.unlock();
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ScheduledFuture<?> schedule(Runnable command2, long delay, TimeUnit unit) {
        this.shutdownLock.readLock().lock();
        try {
            this.checkShutDown();
            int ticks = (int)(unit.toMillis(delay) / 50L);
            TickScheduledTask tickScheduledTask = this.schedule(new TickScheduledTask(Executors.callable(command2), ticks));
            return tickScheduledTask;
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        this.shutdownLock.readLock().lock();
        try {
            this.checkShutDown();
            int ticks = (int)(unit.toMillis(delay) / 50L);
            TickScheduledTask tickScheduledTask = this.schedule(new TickScheduledTask(callable, ticks));
            return tickScheduledTask;
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    @Override
    @Nonnull
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command2, long initialDelay, long period, TimeUnit unit) {
        return this.scheduleWithFixedDelay(command2, initialDelay, period, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command2, long initialDelay, long delay, TimeUnit unit) {
        this.shutdownLock.readLock().lock();
        try {
            this.checkShutDown();
            int initialTicks = (int)(unit.toMillis(initialDelay) / 50L);
            int ticks = (int)(unit.toMillis(delay) / 50L);
            TickScheduledTask tickScheduledTask = this.schedule(new TickScheduledTask(Executors.callable(command2), initialTicks, ticks));
            return tickScheduledTask;
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    @Override
    public void shutdown() {
        this.shuttingDown = true;
    }

    private void shutdownCleanup() {
        this.taskQueue = null;
        this.scheduledTaskList.forEach(tickScheduledTask -> tickScheduledTask.cancel(false));
        this.scheduledTaskList = null;
        this.terminationFuture.complete(null);
    }

    @Override
    @Nonnull
    public List<Runnable> shutdownNow() {
        ArrayList<Runnable> copy;
        this.shutdownLock.writeLock().lock();
        try {
            this.shuttingDown = true;
            copy = new ArrayList<Runnable>(this.taskQueue);
            this.shutdownCleanup();
        }
        finally {
            this.shutdownLock.writeLock().unlock();
        }
        return copy;
    }

    @Override
    public boolean isShutdown() {
        return this.shuttingDown;
    }

    @Override
    public boolean isTerminated() {
        return this.terminationFuture.isDone();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.currentThread() == this.tickingThread) {
            throw new RuntimeException("The ticking thread may not wait for an execution");
        }
        try {
            this.terminationFuture.get(timeout, unit);
        }
        catch (CancellationException e) {
            throw new RuntimeException("Termination future was cancelled", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Termination future threw an exception", e);
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    @Override
    public void execute(Runnable command2) {
        this.shutdownLock.readLock().lock();
        try {
            this.checkShutDown();
            this.taskQueue.add(command2);
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        block11: {
            this.shutdownLock.readLock().lock();
            try {
                if (this.terminationFuture.isDone()) {
                    throw new IllegalStateException("Ticked, although terminated");
                }
                Iterator<Runnable> runnableIter = this.taskQueue.iterator();
                while (runnableIter.hasNext()) {
                    Runnable r = runnableIter.next();
                    r.run();
                    runnableIter.remove();
                }
                if (this.nextTask > this.currentTick) break block11;
                ArrayList<TickScheduledTask> tasksToSchedule = new ArrayList<TickScheduledTask>();
                this.schedulerLock.lock();
                try {
                    TickScheduledTask<?> task = this.scheduledTaskList.peekFirst();
                    while (task != null && (long)task.getExecutorScheduledTick() <= this.currentTick) {
                        task = this.scheduledTaskList.pollFirst();
                        task.run();
                        if (task.isPeriodic()) {
                            ((TickScheduledTask)task).reschedule();
                            tasksToSchedule.add(task);
                        }
                        task = this.scheduledTaskList.peekFirst();
                    }
                    this.nextTask = task == null ? Long.MAX_VALUE : (long)task.getExecutorScheduledTick();
                    tasksToSchedule.forEach(this::scheduleUnsafe);
                }
                finally {
                    this.schedulerLock.unlock();
                }
            }
            finally {
                this.shutdownLock.readLock().unlock();
            }
        }
        if (this.shuttingDown) {
            this.shutdownCleanup();
        }
        ++this.currentTick;
    }

    private class TickScheduledTask<V>
    extends FutureTask<V>
    implements ScheduledFuture<V> {
        private long createdAt;
        private int ticks;
        private boolean periodic;

        private void checkDelay(long delay) {
            if (delay < 0L) {
                throw new IllegalArgumentException("Delay may not be lower than zero");
            }
        }

        private TickScheduledTask(Callable<V> callable, int ticks) {
            super(callable);
            this.checkDelay(ticks);
            this.createdAt = TickExecutor.this.currentTick;
            this.ticks = ticks;
            this.periodic = false;
        }

        private TickScheduledTask(Callable<V> callable, int initialDelay, int ticks) {
            super(callable);
            this.checkDelay(initialDelay);
            this.checkDelay(ticks);
            this.createdAt = TickExecutor.this.currentTick + (long)initialDelay;
            this.ticks = ticks;
            this.periodic = true;
        }

        public int getExecutorScheduledTick() {
            return (int)(this.createdAt + (long)this.ticks);
        }

        public int getTickDelay() {
            return (int)(this.createdAt + (long)this.ticks - TickExecutor.this.currentTick);
        }

        public long getMillisecondsDelay() {
            return (long)this.getTickDelay() * 50L;
        }

        public boolean isPeriodic() {
            return this.periodic;
        }

        private void reschedule() {
            if (!this.periodic) {
                throw new IllegalStateException("Task is not periodic");
            }
            this.createdAt = TickExecutor.this.currentTick;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.getMillisecondsDelay(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.signum(this.getMillisecondsDelay() - o.getDelay(TimeUnit.MILLISECONDS));
        }
    }
}

