/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.energy.systems;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.modcrafters.mclib.energy.IGenericEnergyStorage;
import net.ndrei.teslacorelib.energy.IEnergySystem;
import net.ndrei.teslacorelib.energy.systems.MJSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J+\u0010\f\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lnet/ndrei/teslacorelib/energy/systems/MJSystem;", "Lnet/ndrei/teslacorelib/energy/IEnergySystem;", "()V", "MODID", "", "ModId", "getModId", "()Ljava/lang/String;", "hasCapability", "", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "wrapCapability", "T", "energy", "Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;)Ljava/lang/Object;", "wrapItemStack", "", "stack", "Lnet/minecraft/item/ItemStack;", "wrapTileEntity", "te", "Lnet/minecraft/tileentity/TileEntity;", "side", "Lnet/minecraft/util/EnumFacing;", "Wrapper", "tesla-core-lib"})
public final class MJSystem
implements IEnergySystem {
    @NotNull
    public static final String MODID = "buildcraftlib";
    public static final MJSystem INSTANCE;

    @Override
    @NotNull
    public String getModId() {
        return MODID;
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        return this.isAvailable() && (Intrinsics.areEqual(capability, (Object)MjAPI.CAP_RECEIVER) || Intrinsics.areEqual(capability, (Object)MjAPI.CAP_CONNECTOR));
    }

    @Override
    @Nullable
    public <T> T wrapCapability(@NotNull Capability<T> capability, @NotNull IGenericEnergyStorage energy) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        Intrinsics.checkParameterIsNotNull((Object)energy, (String)"energy");
        if (this.isAvailable() && Intrinsics.areEqual(capability, (Object)MjAPI.CAP_RECEIVER)) {
            return (T)MjAPI.CAP_RECEIVER.cast((Object)new Wrapper(energy));
        }
        if (this.isAvailable() && Intrinsics.areEqual(capability, (Object)MjAPI.CAP_CONNECTOR)) {
            return (T)MjAPI.CAP_CONNECTOR.cast((Object)wrapCapability.1.INSTANCE);
        }
        return null;
    }

    @Nullable
    public Void wrapTileEntity(@NotNull TileEntity te, @NotNull EnumFacing side) {
        Intrinsics.checkParameterIsNotNull((Object)te, (String)"te");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        return null;
    }

    @Nullable
    public Void wrapItemStack(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return null;
    }

    private MJSystem() {
    }

    static {
        MJSystem mJSystem;
        INSTANCE = mJSystem = new MJSystem();
    }

    @Override
    public boolean isAvailable() {
        return IEnergySystem.DefaultImpls.isAvailable(this);
    }

    @Optional.Interface(iface="buildcraft.api.mj.IMjReceiver", modid="buildcraftlib", striprefs=true)
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\f\u0010\u0010\u001a\u00020\f*\u00020\fH\u0002J\f\u0010\u0011\u001a\u00020\f*\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lnet/ndrei/teslacorelib/energy/systems/MJSystem$Wrapper;", "Lbuildcraft/api/mj/IMjReceiver;", "energy", "Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "(Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;)V", "getEnergy", "()Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "canConnect", "", "other", "Lbuildcraft/api/mj/IMjConnector;", "getPowerRequested", "", "receivePower", "microJoules", "simulate", "fromJoules", "toJoules", "tesla-core-lib"})
    public static final class Wrapper
    implements IMjReceiver {
        @NotNull
        private final IGenericEnergyStorage energy;

        public boolean canConnect(@NotNull IMjConnector other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return true;
        }

        private final long fromJoules(long $receiver) {
            return $receiver / (long)10 / MjAPI.MJ;
        }

        private final long toJoules(long $receiver) {
            return $receiver * (long)10 * MjAPI.MJ;
        }

        public long getPowerRequested() {
            return this.toJoules(this.energy.getCapacity() - this.energy.getStored());
        }

        public long receivePower(long microJoules, boolean simulate) {
            return this.toJoules(this.energy.givePower(this.fromJoules(microJoules), simulate));
        }

        @NotNull
        public final IGenericEnergyStorage getEnergy() {
            return this.energy;
        }

        public Wrapper(@NotNull IGenericEnergyStorage energy) {
            Intrinsics.checkParameterIsNotNull((Object)energy, (String)"energy");
            this.energy = energy;
        }
    }
}

