/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.command.ICommand;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;
import silly511.backups.BackupManager;
import silly511.backups.BackupsWorldCapability;
import silly511.backups.Config;
import silly511.backups.commands.BackupsModCommand;
import silly511.backups.commands.RestoreWorldCommandClient;
import silly511.backups.gui.BackupsButton;
import silly511.backups.gui.BackupsButtonFallback;
import silly511.backups.gui.BackupsOnlyWorldEntry;
import silly511.backups.helpers.FileHelper;

@Mod.EventBusSubscriber
@Mod(modid="backups", name="Backups", version="1.5.6", acceptableRemoteVersions="*", updateJSON="https://raw.githubusercontent.com/Silly511/Backups-Mod/master/update.json", acceptedMinecraftVersions="[1.12.2]")
public class BackupsMod {
    public static final String modid = "backups";
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        BackupsWorldCapability.register();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        try {
            File backupsDir = new File(Config.backupsDir);
            File versionFile = new File(backupsDir, "version");
            int version = 0;
            try {
                if (versionFile.isFile()) {
                    version = Integer.parseInt(FileUtils.readFileToString((File)versionFile, (Charset)StandardCharsets.UTF_8));
                }
            }
            catch (IOException | NumberFormatException exception) {
                // empty catch block
            }
            backupsDir.mkdirs();
            FileUtils.write((File)versionFile, (CharSequence)"1", (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            logger.error("Error trying to convert backups", (Throwable)ex);
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new BackupsModCommand());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        BackupManager.serverStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        Path tempWorldsDir = Paths.get("tempWorlds", new String[0]);
        if (!Files.isDirectory(tempWorldsDir, LinkOption.NOFOLLOW_LINKS)) return;
        Class<RegionFileCache> clazz = RegionFileCache.class;
        synchronized (RegionFileCache.class) {
            RegionFileCache.func_76551_a();
            RegionFileCache.field_76553_a = new HashMap();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            try {
                FileHelper.deleteDirectory(tempWorldsDir);
                return;
            }
            catch (IOException ex) {
                logger.error("Unable to delete temp worlds", (Throwable)ex);
            }
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    @SideOnly(value=Side.CLIENT)
    public static void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        String className = event.getGui().getClass().getName();
        if (event.getGui() instanceof GuiWorldSelection) {
            GuiWorldSelection gui = (GuiWorldSelection)event.getGui();
            Minecraft mc = Minecraft.func_71410_x();
            if (event.getButtonList().remove(gui.field_184865_t)) {
                gui.field_184865_t = new BackupsButton(gui.field_184865_t, gui);
                event.getButtonList().add(gui.field_184865_t);
            }
            if (Config.showDeletedWorlds) {
                Set worlds;
                File savesDir = new File("saves");
                File allBackupsDir = new File(Config.backupsDir);
                try {
                    worlds = mc.func_71359_d().func_75799_b().stream().map(WorldSummary::func_75786_a).collect(Collectors.toSet());
                }
                catch (AnvilConverterException ex) {
                    logger.error("Unable to get world list", (Throwable)ex);
                    return;
                }
                block2: for (File backupsDir : allBackupsDir.listFiles()) {
                    if (!backupsDir.isDirectory() || worlds.contains(backupsDir.getName())) continue;
                    for (File backupDir : backupsDir.listFiles()) {
                        if (!new File(backupDir, "backupMetadata.dat").isFile()) continue;
                        gui.field_184866_u.field_186799_w.add(new BackupsOnlyWorldEntry(backupsDir.getName(), gui.field_184866_u, mc.func_71359_d()));
                        continue block2;
                    }
                }
            }
        } else if (className.equals("com.pg85.otg.forge.gui.OTGGuiWorldSelection") || className.equals("com.pg85.otg.forge.gui.mainmenu.OTGGuiWorldSelection")) {
            event.getButtonList().add(new BackupsButtonFallback(event.getGui()));
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            RestoreWorldCommandClient.onPreClientTick();
        }
    }

    @SubscribeEvent
    public static void configChanged(ConfigChangedEvent event) {
        if (event.getModID().equals(modid)) {
            ConfigManager.sync((String)modid, (Config.Type)Config.Type.INSTANCE);
        }
    }
}

