/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.world.chunk.storage.RegionFile;
import silly511.backups.BackupsMod;
import silly511.backups.helpers.FileHelper;
import silly511.backups.util.GzipInputStream;

public class LoadFromBackupMap
extends HashMap<File, RegionFile> {
    private static final long serialVersionUID = 1L;
    private Path backupDir;
    private Path tempWorldDir;

    public LoadFromBackupMap(Path backupDir, Path tempWorldDir) {
        this.backupDir = backupDir;
        this.tempWorldDir = tempWorldDir.toAbsolutePath().normalize();
    }

    @Override
    public RegionFile get(Object key) {
        Path path;
        Path backupFile;
        RegionFile regionFile = (RegionFile)super.get(key);
        if (regionFile == null && key instanceof File && !((File)key).exists() && Files.isRegularFile(backupFile = FileHelper.relativizeAdd(this.tempWorldDir, path = ((File)key).toPath().toAbsolutePath().normalize(), this.backupDir, ".gz"), new LinkOption[0])) {
            try (GzipInputStream in = new GzipInputStream(Files.newInputStream(backupFile, new OpenOption[0]));){
                Files.copy(in, path, new CopyOption[0]);
            }
            catch (IOException ex) {
                BackupsMod.logger.error("Error loading region file from backup", (Throwable)ex);
            }
        }
        return regionFile;
    }
}

