/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.textures;

import com.rwtema.extrautils2.textures.SpriteLoader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;

public abstract class SpriteLoaderProcessing
extends SpriteLoader {
    protected final ResourceLocation baseTexture;

    public SpriteLoaderProcessing(String spriteName, ResourceLocation baseTexture) {
        super(spriteName);
        this.baseTexture = baseTexture;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean load(IResourceManager manager, ResourceLocation location) {
        ResourceLocation baseTexture = this.baseTexture;
        baseTexture = new ResourceLocation(baseTexture.func_110624_b(), String.format("%s/%s%s", "textures", baseTexture.func_110623_a(), ".png"));
        try (IResource iresource = manager.func_110536_a(baseTexture);){
            int mipmapLevels = Minecraft.func_71410_x().field_71474_y.field_151442_I;
            BufferedImage[] abufferedimage = new BufferedImage[1 + mipmapLevels];
            AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_110526_a("animation");
            BufferedImage image = ImageIO.read(iresource.func_110527_b());
            int w = image.getWidth();
            int h = image.getHeight();
            BufferedImage newImage = ImageTypeSpecifier.createFromBufferedImageType(2).createBufferedImage(w, h);
            int n = h / w;
            if (n * w != h) {
                boolean bl = true;
                return bl;
            }
            int[] tempArr = new int[w * w];
            for (int i = 0; i < n; ++i) {
                BufferedImage temp = ImageTypeSpecifier.createFromBufferedImageType(2).createBufferedImage(w, w);
                image.getRGB(0, i * w, w, w, tempArr, 0, w);
                temp.setRGB(0, 0, w, w, tempArr, 0, w);
                this.process(temp, i, n, w);
                temp.getRGB(0, 0, w, w, tempArr, 0, w);
                newImage.setRGB(0, i * w, w, w, tempArr, 0, w);
            }
            abufferedimage[0] = newImage;
            this.loadSprite(abufferedimage, animationmetadatasection);
            this.func_147963_d(mipmapLevels);
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    protected abstract void process(BufferedImage var1, int var2, int var3, int var4);
}

