/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.inventory;

import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.filter.IAEItemFilter;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class AppEngCellInventory
implements IItemHandlerModifiable {
    private final AppEngInternalInventory inv;
    private final ICellInventoryHandler[] handlerForSlot;

    public AppEngCellInventory(IAEAppEngInventory host, int slots) {
        this.inv = new AppEngInternalInventory(host, slots, 1);
        this.handlerForSlot = new ICellInventoryHandler[slots];
    }

    public void setHandler(int slot, ICellInventoryHandler handler) {
        this.handlerForSlot[slot] = handler;
    }

    public void setFilter(IAEItemFilter filter) {
        this.inv.setFilter(filter);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.persist(slot);
        this.inv.setStackInSlot(slot, stack);
        this.cleanup(slot);
    }

    public int getSlots() {
        return this.inv.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        this.persist(slot);
        return this.inv.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        this.persist(slot);
        ItemStack ret = this.inv.insertItem(slot, stack, simulate);
        this.cleanup(slot);
        return ret;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.persist(slot);
        ItemStack ret = this.inv.extractItem(slot, amount, simulate);
        this.cleanup(slot);
        return ret;
    }

    public int getSlotLimit(int slot) {
        return this.inv.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.inv.isItemValid(slot, stack);
    }

    public void persist() {
        for (int i = 0; i < this.getSlots(); ++i) {
            this.persist(i);
        }
    }

    private void persist(int slot) {
        ICellInventory ci;
        if (this.handlerForSlot[slot] != null && (ci = this.handlerForSlot[slot].getCellInv()) != null) {
            ci.persist();
        }
    }

    private void cleanup(int slot) {
        ICellInventory ci;
        if (this.handlerForSlot[slot] != null && ((ci = this.handlerForSlot[slot].getCellInv()) == null || ci.getItemStack() != this.inv.getStackInSlot(slot))) {
            this.handlerForSlot[slot] = null;
        }
    }
}

