/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api;

import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.spell_power.SpellPowerMod;
import net.spell_power.config.AttributesConfig;
import org.jetbrains.annotations.Nullable;

public class SpellResistance {
    public static double resist(LivingEntity target, double damage, DamageSource source) {
        double modifier = 1.0;
        for (Attributes.Entry resistance : Attributes.all) {
            if (!target.m_21204_().m_22171_(resistance.attribute) || !source.m_269533_(resistance.damageTypes)) continue;
            double value = target.m_21133_(resistance.attribute);
            double maxValue = resistance.maxValue;
            switch (resistance.curve) {
                case LINEAR: {
                    modifier *= 1.0 - value / maxValue * (double)((AttributesConfig)SpellPowerMod.attributesConfig.value).resistance_reduction_cap;
                    break;
                }
                case SQUARE: {
                    double sqrt = Math.sqrt(value * maxValue);
                    modifier *= 1.0 - sqrt / maxValue * (double)((AttributesConfig)SpellPowerMod.attributesConfig.value).resistance_reduction_cap;
                }
            }
        }
        return damage * modifier;
    }

    public static class Attributes {
        public static final ArrayList<Entry> all = new ArrayList();
        public static final Entry GENERIC = Attributes.entry("generic", "all", Curve.LINEAR, 100.0, true);

        public static Entry entry(String name, String tagName, Curve curve, double maxValue, boolean tracked) {
            return Attributes.entry("resistance." + name, new ResourceLocation("spell_power", tagName), curve, maxValue, tracked);
        }

        public static Entry entry(String name, ResourceLocation damageTagId, Curve curve, double maxValue, boolean tracked) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)damageTagId);
            Entry entry = new Entry(name, (TagKey<DamageType>)tag, curve, maxValue, tracked);
            all.add(entry);
            return entry;
        }

        public static class Entry {
            public final ResourceLocation id;
            public final String translationKey;
            public final Attribute attribute;
            public final double baseValue;
            public final TagKey<DamageType> damageTypes;
            public final double maxValue;
            public Curve curve;
            @Nullable
            public Holder<Attribute> entry;

            public Entry(String name, TagKey<DamageType> tag, Curve curve, double maxValue, boolean tracked) {
                this.id = ResourceLocation.m_214293_((String)"spell_power", (String)name);
                this.translationKey = "attribute.name.spell_power." + name;
                double baseValue = 0.0;
                double minValue = 0.0;
                this.attribute = new RangedAttribute(this.translationKey, baseValue, minValue, maxValue).m_22084_(tracked);
                this.baseValue = baseValue;
                this.maxValue = maxValue;
                this.curve = curve;
                this.damageTypes = tag;
            }

            public void register() {
            }
        }
    }

    public static enum Curve {
        LINEAR,
        SQUARE;

    }
}

