/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api;

import com.google.gson.annotations.JsonAdapter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.spell_power.api.misc.SpellSchoolJSONAdapter;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=SpellSchoolJSONAdapter.class)
public class SpellSchool {
    public final Archetype archetype;
    public final ResourceLocation id;
    public final int color;
    public final Attribute attribute;
    public Manage attributeManagement = Manage.INTERNAL;
    @Nullable
    public final MobEffect boostEffect;
    public Manage powerEffectManagement = Manage.INTERNAL;
    public final ResourceKey<DamageType> damageType;
    private HashMap<Trait, ArrayList<Source>> sources = SpellSchool.emptyTraits();

    public SpellSchool(Archetype archetype, ResourceLocation id, int color, ResourceKey<DamageType> damageType, Attribute attribute) {
        this(archetype, id, color, damageType, attribute, null);
    }

    public SpellSchool(Archetype archetype, ResourceLocation id, int color, ResourceKey<DamageType> damageType, Attribute attribute, @Nullable MobEffect boostEffect) {
        this.archetype = archetype;
        this.id = id;
        this.color = color;
        this.damageType = damageType;
        this.attribute = attribute;
        this.boostEffect = boostEffect;
    }

    private static HashMap<Trait, ArrayList<Source>> emptyTraits() {
        HashMap<Trait, ArrayList<Source>> map = new HashMap<Trait, ArrayList<Source>>();
        for (Trait trait : Trait.values()) {
            map.put(trait, new ArrayList());
        }
        return map;
    }

    public void addSource(Trait trait, Apply apply, Function<QueryArgs, Double> function) {
        this.addSource(trait, new Source(apply, function));
    }

    public void addSource(Trait trait, Source source) {
        this.sources.get((Object)trait).add(source);
        this.sources.get((Object)trait).sort(Comparator.comparingInt(a -> a.apply.ordinal()));
    }

    public double getValue(Trait trait, QueryArgs query) {
        ArrayList<Source> traitSources = this.sources.get((Object)trait);
        float value = 0.0f;
        switch (trait) {
            case POWER: 
            case CRIT_CHANCE: {
                value = 0.0f;
                break;
            }
            case HASTE: 
            case CRIT_DAMAGE: {
                value = 1.0f;
            }
        }
        float multiplier = 1.0f;
        for (Source source : traitSources) {
            switch (source.apply) {
                case ADD: {
                    value = (float)((double)value + source.function.apply(query));
                    break;
                }
                case MULTIPLY: {
                    multiplier = (float)((double)multiplier + source.function.apply(query));
                }
            }
        }
        return value *= multiplier;
    }

    public static enum Archetype {
        ARCHERY,
        MAGIC,
        MELEE;

    }

    public static enum Manage {
        INTERNAL,
        EXTERNAL;


        public boolean isInternal() {
            return this == INTERNAL;
        }
    }

    public static enum Trait {
        POWER,
        HASTE,
        CRIT_CHANCE,
        CRIT_DAMAGE;

    }

    public record Source(Apply apply, Function<QueryArgs, Double> function) {
    }

    public static enum Apply {
        ADD,
        MULTIPLY;

    }

    public record QueryArgs(LivingEntity entity) {
    }
}

