/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.spell_power.SpellPowerMod;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.enchantment.Enchantments_SpellPowerMechanics;
import net.spell_power.api.enchantment.SpellPowerEnchanting;
import net.spell_power.config.AttributesConfig;
import net.spell_power.internals.AmplifierEnchantment;
import net.spell_power.internals.CustomEntityAttribute;
import net.spell_power.internals.SpellStatusEffect;
import org.jetbrains.annotations.Nullable;

public class SpellSchools {
    public static final String DEFAULT_NAMESPACE = "spell_power";
    private static final LinkedHashMap<ResourceLocation, SpellSchool> REGISTRY = new LinkedHashMap();
    public static final SpellSchool ARCANE = SpellSchools.register(SpellSchools.createMagic("arcane", true, 0xFF66FF));
    public static final SpellSchool FIRE = SpellSchools.register(SpellSchools.createMagic("fire", true, 0xFF3300));
    public static final SpellSchool FROST = SpellSchools.register(SpellSchools.createMagic("frost", true, 0xCCFFFF));
    public static final SpellSchool HEALING = SpellSchools.register(SpellSchools.createMagic("healing", true, 0x66FF66));
    public static final SpellSchool LIGHTNING = SpellSchools.register(SpellSchools.createMagic("lightning", true, 0xFFFF99));
    public static final SpellSchool SOUL = SpellSchools.register(SpellSchools.createMagic("soul", true, 3003610));

    public static SpellSchool register(SpellSchool school) {
        REGISTRY.put(school.id, school);
        return school;
    }

    public static Set<SpellSchool> all() {
        return new LinkedHashSet<SpellSchool>(REGISTRY.values());
    }

    public static SpellSchool createMagic(String name, int color) {
        return SpellSchools.createMagic(new ResourceLocation(DEFAULT_NAMESPACE, name.toLowerCase()), color);
    }

    public static SpellSchool createMagic(String name, boolean customDamageType, int color) {
        return SpellSchools.createMagic(new ResourceLocation(DEFAULT_NAMESPACE, name.toLowerCase()), customDamageType, color);
    }

    public static SpellSchool createMagic(ResourceLocation id, int color) {
        SpellStatusEffect powerEffect = new SpellStatusEffect(MobEffectCategory.BENEFICIAL, color);
        String translationPrefix = "attribute.name." + id.m_135827_() + ".";
        Attribute attribute = new CustomEntityAttribute(translationPrefix + id.m_135815_(), 0.0, 0.0, 2048.0, id).m_22084_(true);
        return SpellSchools.createMagic(id, color, attribute, powerEffect);
    }

    public static SpellSchool createMagic(ResourceLocation id, boolean customDamageType, int color) {
        SpellStatusEffect powerEffect = new SpellStatusEffect(MobEffectCategory.BENEFICIAL, color);
        String translationPrefix = "attribute.name." + id.m_135827_() + ".";
        Attribute attribute = new CustomEntityAttribute(translationPrefix + id.m_135815_(), 0.0, 0.0, 2048.0, id).m_22084_(true);
        return SpellSchools.createMagic(id, color, customDamageType, attribute, powerEffect);
    }

    @Deprecated
    public static SpellSchool createMagic(ResourceLocation id, int color, Attribute powerAttribute, MobEffect powerEffect) {
        return SpellSchools.createMagic(id, color, false, powerAttribute, powerEffect);
    }

    public static SpellSchool createMagic(ResourceLocation id, int color, boolean customDamageType, Attribute powerAttribute, MobEffect powerEffect) {
        SpellSchool school = new SpellSchool(SpellSchool.Archetype.MAGIC, id, color, (ResourceKey<DamageType>)(customDamageType ? ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)id) : DamageTypes.f_268515_), powerAttribute, powerEffect);
        return SpellSchools.configureAsMagic(school, powerAttribute);
    }

    public static SpellSchool configureAsMagic(SpellSchool school, Attribute powerAttribute) {
        school.addSource(SpellSchool.Trait.POWER, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> query.entity().m_21133_(powerAttribute)));
        SpellSchools.configureSpellHaste(school);
        SpellSchools.configureSpellCritChance(school);
        SpellSchools.configureSpellCritDamage(school);
        return school;
    }

    public static SpellSchool configureSpellHaste(SpellSchool school) {
        school.addSource(SpellSchool.Trait.HASTE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            double value = query.entity().m_21133_((Attribute)SpellPowerMechanics.HASTE.attribute);
            double rate = value / 100.0;
            return rate - 1.0;
        }));
        school.addSource(SpellSchool.Trait.HASTE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            AmplifierEnchantment enchantment = Enchantments_SpellPowerMechanics.HASTE;
            int level = SpellPowerEnchanting.getEnchantmentLevelEquipmentSum(enchantment, query.entity());
            return enchantment.amplified(0.0, level);
        }));
        return school;
    }

    public static SpellSchool configureSpellCritChance(SpellSchool school) {
        school.addSource(SpellSchool.Trait.CRIT_CHANCE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_chance_percentage + query.entity().m_21133_((Attribute)SpellPowerMechanics.CRITICAL_CHANCE.attribute);
            return value / 100.0 - 1.0;
        }));
        school.addSource(SpellSchool.Trait.CRIT_CHANCE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            AmplifierEnchantment enchantment = Enchantments_SpellPowerMechanics.CRITICAL_CHANCE;
            int level = SpellPowerEnchanting.getEnchantmentLevelEquipmentSum(enchantment, query.entity());
            return enchantment.amplified(0.0, level);
        }));
        return school;
    }

    public static SpellSchool configureSpellCritDamage(SpellSchool school) {
        school.addSource(SpellSchool.Trait.CRIT_DAMAGE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_damage_percentage + query.entity().m_21133_((Attribute)SpellPowerMechanics.CRITICAL_DAMAGE.attribute);
            double rate = value / 100.0;
            return rate - 1.0;
        }));
        school.addSource(SpellSchool.Trait.CRIT_DAMAGE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            AmplifierEnchantment enchantment = Enchantments_SpellPowerMechanics.CRITICAL_DAMAGE;
            int level = SpellPowerEnchanting.getEnchantmentLevelEquipmentSum(enchantment, query.entity());
            return enchantment.amplified(0.0, level);
        }));
        return school;
    }

    @Nullable
    public static SpellSchool getSchool(String idString) {
        String string = idString.toLowerCase(Locale.US);
        ResourceLocation id = new ResourceLocation(string);
        if (id.m_135827_().equals("minecraft")) {
            id = new ResourceLocation(DEFAULT_NAMESPACE, id.m_135815_());
        }
        return REGISTRY.get(id);
    }

    @Deprecated
    public static class IdTypeAdapter
    extends TypeAdapter<SpellSchool> {
        public void write(JsonWriter jsonWriter, SpellSchool school) throws IOException {
            jsonWriter.value(school.id.toString());
        }

        public SpellSchool read(JsonReader jsonReader) throws IOException {
            return SpellSchools.getSchool(jsonReader.nextString());
        }
    }
}

