/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api.enchantment;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.spell_power.SpellPowerMod;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.enchantment.EnchantmentRestriction;
import net.spell_power.config.EnchantmentsConfig;
import net.spell_power.internals.AmplifierEnchantment;
import net.spell_power.internals.MagicProtectionEnchantment;

public class Enchantments_SpellPowerMechanics {
    public static final ResourceLocation criticalChanceId = new ResourceLocation("spell_power", SpellPowerMechanics.CRITICAL_CHANCE.name);
    public static final AmplifierEnchantment CRITICAL_CHANCE = new AmplifierEnchantment(Enchantment.Rarity.UNCOMMON, AmplifierEnchantment.Operation.ADD, Enchantments_SpellPowerMechanics.config().critical_chance, EnchantmentCategory.BREAKABLE, EquipmentSlot.values()).requireTag(new ResourceLocation("spell_power", "enchant_critical_chance"));
    public static final ResourceLocation criticalDamageId = new ResourceLocation("spell_power", SpellPowerMechanics.CRITICAL_DAMAGE.name);
    public static final AmplifierEnchantment CRITICAL_DAMAGE = new AmplifierEnchantment(Enchantment.Rarity.UNCOMMON, AmplifierEnchantment.Operation.ADD, Enchantments_SpellPowerMechanics.config().critical_damage, EnchantmentCategory.BREAKABLE, EquipmentSlot.values()).requireTag(new ResourceLocation("spell_power", "enchant_critical_damage"));
    public static final ResourceLocation hasteId = new ResourceLocation("spell_power", SpellPowerMechanics.HASTE.name);
    public static final AmplifierEnchantment HASTE = new AmplifierEnchantment(Enchantment.Rarity.RARE, AmplifierEnchantment.Operation.ADD, Enchantments_SpellPowerMechanics.config().haste, EnchantmentCategory.BREAKABLE, EquipmentSlot.values()).requireTag(new ResourceLocation("spell_power", "enchant_haste"));
    public static EquipmentSlot[] ALL_ARMOR = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final String magicProtectionName = "magic_protection";
    public static final ResourceLocation magicProtectionId = new ResourceLocation("spell_power", "magic_protection");
    public static final MagicProtectionEnchantment MAGIC_PROTECTION = new MagicProtectionEnchantment(Enchantment.Rarity.RARE, Enchantments_SpellPowerMechanics.config().magic_protection, ALL_ARMOR);
    public static final Map<ResourceLocation, Enchantment> all;

    private static EnchantmentsConfig config() {
        return (EnchantmentsConfig)((Object)SpellPowerMod.enchantmentConfig.value);
    }

    static {
        HashMap<ResourceLocation, AmplifierEnchantment> secondaries = new HashMap<ResourceLocation, AmplifierEnchantment>();
        secondaries.put(criticalChanceId, CRITICAL_CHANCE);
        secondaries.put(criticalDamageId, CRITICAL_DAMAGE);
        secondaries.put(hasteId, HASTE);
        all = new HashMap<ResourceLocation, Enchantment>();
        all.putAll(secondaries);
        all.put(magicProtectionId, (Enchantment)MAGIC_PROTECTION);
        for (Map.Entry entry : secondaries.entrySet()) {
            AmplifierEnchantment enchantment = (AmplifierEnchantment)((Object)entry.getValue());
            EnchantmentRestriction.prohibit(enchantment, itemStack -> {
                boolean typeMatches = enchantment.matchesRequiredTag(itemStack);
                return !typeMatches;
            });
        }
    }
}

