/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api.enchantment;

import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.spell_power.api.enchantment.SpellPowerEnchanting;

public enum ItemType {
    ARMOR,
    MAGICAL_ARMOR,
    MAGICAL_WEAPON;


    public boolean matches(ItemStack stack) {
        switch (this) {
            case ARMOR: {
                return stack.m_41720_() instanceof ArmorItem;
            }
            case MAGICAL_ARMOR: {
                Item item = stack.m_41720_();
                if (item instanceof ArmorItem) {
                    ArmorItem armor = (ArmorItem)item;
                    return SpellPowerEnchanting.isArmorRegistered((Item)armor) || !SpellPowerEnchanting.relevantSchools(stack, armor.m_40402_()).isEmpty();
                }
                return false;
            }
            case MAGICAL_WEAPON: {
                return SpellPowerEnchanting.isAllowedForWeapon(stack);
            }
        }
        return true;
    }

    public boolean requiresMagic() {
        return this == MAGICAL_ARMOR || this == MAGICAL_WEAPON;
    }
}

