/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.internals;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.tinyconfig.models.EnchantmentConfig;
import org.jetbrains.annotations.Nullable;

public class AmplifierEnchantment
extends Enchantment {
    public Operation operation;
    @Nullable
    protected ResourceLocation tagId;
    public EnchantmentConfig config;

    public double amplified(double value, int level) {
        switch (this.operation) {
            case ADD: {
                return value += (double)((float)level * this.config.bonus_per_level);
            }
            case MULTIPLY: {
                return value *= (double)(1.0f + (float)level * this.config.bonus_per_level);
            }
        }
        return 0.0;
    }

    public AmplifierEnchantment(Enchantment.Rarity weight, Operation operation, EnchantmentConfig config, EnchantmentCategory type, EquipmentSlot[] slotTypes) {
        super(weight, type, slotTypes);
        this.operation = operation;
        this.config = config;
    }

    public AmplifierEnchantment requireTag(ResourceLocation tagId) {
        this.tagId = tagId;
        return this;
    }

    public boolean m_6594_() {
        return super.m_6594_() && this.config.enabled;
    }

    public boolean m_6592_() {
        return super.m_6592_() && this.config.enabled;
    }

    public int m_6586_() {
        if (!this.config.enabled) {
            return 0;
        }
        return this.config.max_level;
    }

    public int m_6183_(int level) {
        return this.config.min_cost + (level - 1) * this.config.step_cost;
    }

    public int m_6175_(int level) {
        return super.m_6183_(level) + 50;
    }

    protected boolean m_5975_(Enchantment other) {
        boolean otherIsRanged = other.f_44672_ == EnchantmentCategory.BOW || other.f_44672_ == EnchantmentCategory.CROSSBOW;
        return !otherIsRanged && super.m_5975_(other);
    }

    public boolean matchesRequiredTag(ItemStack stack) {
        if (this.tagId == null) {
            return true;
        }
        return stack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)this.tagId));
    }

    public static enum Operation {
        ADD,
        MULTIPLY;

    }
}

