/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.mixin;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.spell_power.api.enchantment.EnchantmentRestriction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Enchantment.class})
public abstract class EnchantmentMixin {
    @Inject(method={"isAcceptableItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void isAcceptableItem_HEAD_SpellPower(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Enchantment enchantment = (Enchantment)this;
        if (EnchantmentRestriction.isProhibited(enchantment, stack)) {
            cir.setReturnValue((Object)false);
            cir.cancel();
            return;
        }
        if (EnchantmentRestriction.isPermitted(enchantment, stack)) {
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
    }
}

