/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.mixin;

import java.util.Map;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.Level;
import net.spell_power.SpellPowerMod;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellResistance;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.spell_power.config.AttributesConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin
extends Entity {
    LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"createLivingAttributes()Lnet/minecraft/entity/attribute/DefaultAttributeContainer$Builder;"}, require=1, allow=1, at={@At(value="RETURN")})
    private static void addAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> info) {
        if (SpellPowerMod.attributeScope() == AttributesConfig.AttributeScope.LIVING_ENTITY) {
            for (Map.Entry<String, SpellPowerMechanics.Entry> entry : SpellPowerMechanics.all.entrySet()) {
                SpellPowerMechanics.Entry secondary = entry.getValue();
                ((AttributeSupplier.Builder)info.getReturnValue()).m_22266_((Attribute)secondary.attribute);
            }
            for (SpellSchool school : SpellSchools.all()) {
                if (!school.attributeManagement.isInternal()) continue;
                Attribute attribute = school.attribute;
                ((AttributeSupplier.Builder)info.getReturnValue()).m_22266_(attribute);
            }
            for (SpellResistance.Attributes.Entry resistance : SpellResistance.Attributes.all) {
                ((AttributeSupplier.Builder)info.getReturnValue()).m_22266_(resistance.attribute);
            }
        }
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), ordinal=0)
    private float damage_resistance(float amount, DamageSource source) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.m_6673_(source) || entity.m_21224_()) {
            return amount;
        }
        return (float)SpellResistance.resist(entity, amount, source);
    }
}

