/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.internal;

import net.fabric_extras.ranged_weapon.api.CustomRangedWeapon;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ScalingUtil {
    private static final float STANDARD_BOW_VELOCITY = 3.0f;
    private static final float STANDARD_BOW_DAMAGE = 6.0f;
    private static final float STANDARD_CROSSBOW_VELOCITY = 3.15f;
    private static final float STANDARD_CROSSBOW_DAMAGE = 9.0f;
    public static final Scaling BOW_BASELINE = new Scaling(3.0, 6.0);
    public static final Scaling CROSSBOW_BASELINE = new Scaling(3.15f, 9.0);

    public static Scaling scaling(ItemStack itemStack, double damage) {
        CustomRangedWeapon rangedWeapon;
        float customVelocity;
        Scaling baseline;
        Item item = itemStack.m_41720_();
        if (item instanceof BowItem) {
            baseline = BOW_BASELINE;
        } else if (item instanceof CrossbowItem) {
            baseline = CROSSBOW_BASELINE;
        } else {
            return new Scaling(1.0, 1.0);
        }
        double velocityMultiplier = 1.0;
        if (item instanceof CustomRangedWeapon && (customVelocity = (rangedWeapon = (CustomRangedWeapon)item).getRangedWeaponConfig().velocity()) > 0.0f) {
            velocityMultiplier = ScalingUtil.arrowVelocityMultiplier(baseline.velocity, customVelocity);
        }
        double damageMultiplier = ScalingUtil.arrowDamageMultiplier(baseline.damage, damage, baseline.velocity, 0.0);
        return new Scaling(velocityMultiplier, damageMultiplier);
    }

    public static double arrowVelocityMultiplier(double standardVelocity, double customVelocity) {
        return customVelocity / standardVelocity;
    }

    public static double arrowDamageMultiplier(double standardDamage, double attributeDamage, double standardVelocity, double customVelocity) {
        double multiplier = attributeDamage / standardDamage;
        if (customVelocity > 0.0) {
            multiplier *= standardVelocity / customVelocity;
        }
        return multiplier;
    }

    public record Scaling(double velocity, double damage) {
    }
}

