/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.mixin.item;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.fabric_extras.ranged_weapon.api.CustomRangedWeapon;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.fabric_extras.ranged_weapon.internal.ScalingUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={BowItem.class})
public class BowItemMixin {
    private static final float STANDARD_DAMAGE = 6.0f;
    private static final float STANDARD_VELOCITY = 3.0f;

    private RangedConfig config() {
        return ((CustomRangedWeapon)((Object)this)).getRangedWeaponConfig();
    }

    public float getPullProgress_RWA(int useTicks) {
        float pullTime = this.config().pull_time() > 0 ? (float)this.config().pull_time() : 20.0f;
        float f = (float)useTicks / pullTime;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @WrapOperation(method={"onStoppedUsing"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/BowItem;getPullProgress(I)F")})
    private float applyCustomPullTime(int ticks, Operation<Float> original) {
        if (this.config().pull_time() > 0) {
            return this.getPullProgress_RWA(ticks);
        }
        return ((Float)original.call(new Object[]{ticks})).floatValue();
    }

    @WrapWithCondition(method={"onStoppedUsing"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z")})
    private boolean applyCustomVelocity(Level world, Entity entity) {
        if (entity instanceof AbstractArrow) {
            AbstractArrow projectile = (AbstractArrow)entity;
            if (this.config().velocity() > 0.0f) {
                projectile.m_20256_(projectile.m_20184_().m_82490_((double)(this.config().velocity() / 3.0f)));
            }
        }
        return true;
    }

    @WrapOperation(method={"onStoppedUsing"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z")})
    private boolean applyCustomDamage(Level instance, Entity entity, Operation<Boolean> original, ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (entity instanceof AbstractArrow) {
            AbstractArrow projectile = (AbstractArrow)entity;
            double rangedDamage = user.m_21133_(EntityAttributes_RangedWeapon.DAMAGE.attribute);
            if (rangedDamage > 0.0) {
                double multiplier = ScalingUtil.arrowDamageMultiplier(6.0, rangedDamage, 3.0, this.config().velocity());
                double finalDamage = projectile.m_36789_() * multiplier;
                projectile.m_36781_(finalDamage);
            }
        }
        return (Boolean)original.call(new Object[]{world, entity});
    }
}

