/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.mixin.item;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.fabric_extras.ranged_weapon.api.CrossbowMechanics;
import net.fabric_extras.ranged_weapon.api.CustomRangedWeapon;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.fabric_extras.ranged_weapon.internal.ScalingUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public class CrossbowItemMixin {
    @Shadow
    @Final
    private static float f_150795_;
    private static final float STANDARD_VELOCITY;
    private static final float STANDARD_DAMAGE = 9.0f;

    private RangedConfig config() {
        return ((CustomRangedWeapon)((Object)this)).getRangedWeaponConfig();
    }

    public float getPullProgress_RWA(int useTicks) {
        float pullTime = this.config().pull_time() > 0 ? (float)this.config().pull_time() : 25.0f;
        float f = (float)useTicks / pullTime;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Inject(method={"getPullTime"}, at={@At(value="HEAD")}, cancellable=true)
    private static void applyCustomPullTime_RWA(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        CustomRangedWeapon weapon;
        int pullTime;
        Item item = stack.m_41720_();
        if (item instanceof CustomRangedWeapon && (pullTime = (weapon = (CustomRangedWeapon)item).getRangedWeaponConfig().pull_time()) > 0) {
            pullTime = CrossbowMechanics.PullTime.modifier.getPullTime(pullTime, stack);
            cir.setReturnValue((Object)pullTime);
            cir.cancel();
        }
    }

    @ModifyVariable(method={"shoot"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    private static float applyCustomVelocity_RWA(float speed, Level world, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, ItemStack projectile, float soundPitch, boolean creative, float speed1, float divergence, float simulated) {
        CustomRangedWeapon weapon;
        float customVelocity;
        Item item = crossbow.m_41720_();
        if (item instanceof CustomRangedWeapon && (customVelocity = (weapon = (CustomRangedWeapon)item).getRangedWeaponConfig().velocity()) > 0.0f) {
            return speed * (customVelocity / f_150795_);
        }
        return speed;
    }

    @WrapOperation(method={"shoot"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z")})
    private static boolean applyCustomDamage(Level instance, Entity entity, Operation<Boolean> original, Level world, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, ItemStack projectileStack, float soundPitch, boolean creative, float speed, float divergence, float simulated) {
        Item item = crossbow.m_41720_();
        if (entity instanceof AbstractArrow) {
            AbstractArrow projectileEntity = (AbstractArrow)entity;
            if (item instanceof CustomRangedWeapon) {
                CustomRangedWeapon weapon = (CustomRangedWeapon)item;
                double rangedDamage = shooter.m_21133_(EntityAttributes_RangedWeapon.DAMAGE.attribute);
                if (rangedDamage > 0.0) {
                    double multiplier = ScalingUtil.arrowDamageMultiplier(9.0, rangedDamage, STANDARD_VELOCITY, weapon.getRangedWeaponConfig().velocity());
                    double finalDamage = projectileEntity.m_36789_() * multiplier;
                    projectileEntity.m_36781_(finalDamage);
                }
            }
        }
        return (Boolean)original.call(new Object[]{world, entity});
    }

    static {
        STANDARD_VELOCITY = f_150795_;
    }
}

