/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.Comparator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.effects.instance.SimplyStatusEffectInstance;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class AscendancyAbilities {
    public static int getAscendancyPoints(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (FabricLoader.getInstance().isModLoaded("prominent") && BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation("eldritch_end:corruption")) != null) {
                return (int)player.m_21133_((Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation("eldritch_end:corruption")));
            }
            return HelperMethods.countUnlockedSkills("ascendancy", serverPlayer);
        }
        return 0;
    }

    public static boolean righteousHammers(Player player) {
        player.m_7292_(new MobEffectInstance(EffectRegistry.RIGHTEOUSHAMMERS, 800, 1 + AscendancyAbilities.getAscendancyPoints(player) / 10, false, false, true));
        return true;
    }

    public static boolean boneArmor(Player player) {
        player.m_7292_(new MobEffectInstance(EffectRegistry.BONEARMOR, 800, 3 + AscendancyAbilities.getAscendancyPoints(player) / 10, false, false, true));
        return true;
    }

    public static void boneArmorEffect(ServerPlayer player) {
        if (HelperMethods.isUnlocked("simplyskills:ascendancy", SkillReferencePosition.ascendancyBoneArmor, (LivingEntity)player) && player.m_21023_(EffectRegistry.BONEARMOR)) {
            HelperMethods.decrementStatusEffect((LivingEntity)player, EffectRegistry.BONEARMOR);
        }
    }

    public static boolean cyclonicCleave(Player player) {
        if (FabricLoader.getInstance().isModLoaded("prominent")) {
            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:cyclonic_cleave_prom", 3, (Entity)player, null);
        } else {
            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:cyclonic_cleave", 3, (Entity)player, null);
        }
        return true;
    }

    public static boolean magicCircle(Player player) {
        player.m_7292_(new MobEffectInstance(EffectRegistry.MAGICCIRCLE, 240 + AscendancyAbilities.getAscendancyPoints(player), 0, false, false, true));
        player.m_7292_(new MobEffectInstance(EffectRegistry.IMMOBILIZE, 25, 0, false, false, true));
        player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SPELL_RADIANT_HIT, SoundSource.PLAYERS, 0.2f, 0.9f);
        return true;
    }

    public static boolean magicCircleEffect(Player player) {
        return AscendancyAbilities.getAscendancyPoints(player) > 29 && player.m_21023_(EffectRegistry.MAGICCIRCLE);
    }

    public static boolean arcaneSlash(Player player) {
        SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:arcane_slash", 3, (Entity)player, null);
        player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SPELL_SLASH, SoundSource.PLAYERS, 0.4f, 1.1f);
        if (AscendancyAbilities.getAscendancyPoints(player) > 9) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.ARCANEATTUNEMENT, 60, 1 + AscendancyAbilities.getAscendancyPoints(player) / 10, 19);
        }
        return true;
    }

    public static boolean agony(Player player) {
        LivingEntity ee;
        AABB box;
        ServerLevel world = (ServerLevel)player.m_9236_();
        Entity closestEntity = world.m_6249_((Entity)player, box = HelperMethods.createBox((Entity)player, 10), EntitySelector.f_20403_).stream().min(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)player))).orElse(null);
        if (closestEntity != null && closestEntity instanceof LivingEntity && HelperMethods.checkFriendlyFire(ee = (LivingEntity)closestEntity, player)) {
            SimplyStatusEffectInstance agonyEffect = new SimplyStatusEffectInstance(EffectRegistry.AGONY, 200 + AscendancyAbilities.getAscendancyPoints(player), 0, false, false, true);
            agonyEffect.setSourceEntity((LivingEntity)player);
            ee.m_7292_((MobEffectInstance)agonyEffect);
            HelperMethods.spawnWaistHeightParticles(world, (ParticleOptions)ParticleTypes.f_123762_, (Entity)player, (Entity)ee, 20);
            player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.MAGIC_SHAMANIC_SPELL_04, SoundSource.PLAYERS, 0.2f, 1.0f);
            return true;
        }
        return false;
    }

    public static void agonyEffect(Player playerAttacker, LivingEntity livingEntity) {
        Player sourcePlayer;
        LivingEntity sourceEntity;
        if (!(livingEntity.m_21124_(EffectRegistry.AGONY) instanceof SimplyStatusEffectInstance)) {
            return;
        }
        SimplyStatusEffectInstance agonyEffect = (SimplyStatusEffectInstance)livingEntity.m_21124_(EffectRegistry.AGONY);
        livingEntity.f_19802_ = 0;
        livingEntity.m_6469_(playerAttacker.m_269291_().m_269104_((Entity)playerAttacker, (Entity)playerAttacker), (float)(0.1 * HelperMethods.getHighestAttributeValue(playerAttacker)));
        livingEntity.f_19802_ = 0;
        if (agonyEffect != null && (sourceEntity = agonyEffect.getSourceEntity()) instanceof Player && AscendancyAbilities.getAscendancyPoints(sourcePlayer = (Player)sourceEntity) > 29) {
            playerAttacker.m_5634_((float)(0.1 * SpellPower.getSpellPower((SpellSchool)SpellSchools.HEALING, (LivingEntity)sourcePlayer).randomValue()));
        }
    }

    public static boolean torment(Player player) {
        LivingEntity ee;
        AABB box;
        ServerLevel world = (ServerLevel)player.m_9236_();
        Entity closestEntity = world.m_6249_((Entity)player, box = HelperMethods.createBox((Entity)player, 10), EntitySelector.f_20403_).stream().min(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)player))).orElse(null);
        if (closestEntity != null && closestEntity instanceof LivingEntity && HelperMethods.checkFriendlyFire(ee = (LivingEntity)closestEntity, player)) {
            SimplyStatusEffectInstance tormentEffect = new SimplyStatusEffectInstance(EffectRegistry.TORMENT, 160 + AscendancyAbilities.getAscendancyPoints(player), 0, false, false, true);
            tormentEffect.setSourceEntity((LivingEntity)player);
            ee.m_7292_((MobEffectInstance)tormentEffect);
            player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.MAGIC_SHAMANIC_SPELL_04, SoundSource.PLAYERS, 0.2f, 1.0f);
            if (AscendancyAbilities.getAscendancyPoints(player) > 29) {
                SimplyStatusEffectInstance tauntedEffect = new SimplyStatusEffectInstance(EffectRegistry.TAUNTED, 160 + AscendancyAbilities.getAscendancyPoints(player), 0, false, false, true);
                tauntedEffect.setSourceEntity((LivingEntity)player);
                ee.m_7292_((MobEffectInstance)tauntedEffect);
            }
            HelperMethods.spawnWaistHeightParticles(world, (ParticleOptions)ParticleTypes.f_123762_, (Entity)player, (Entity)ee, 20);
            return true;
        }
        return false;
    }

    public static boolean tormentEffect(Player player, DamageSource source, float amount) {
        LivingEntity attacker;
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity).m_21023_(EffectRegistry.TORMENT)) {
            Player sourcePlayer;
            if (!(attacker.m_21124_(EffectRegistry.TORMENT) instanceof SimplyStatusEffectInstance)) {
                return false;
            }
            SimplyStatusEffectInstance tormentEffect = (SimplyStatusEffectInstance)attacker.m_21124_(EffectRegistry.TORMENT);
            LivingEntity livingEntity = tormentEffect.getSourceEntity();
            if (livingEntity instanceof Player && (sourcePlayer = (Player)livingEntity) == player) {
                attacker.m_6469_(source, amount);
                return true;
            }
        }
        return false;
    }

    public static boolean rapidfire(Player player) {
        player.m_7292_(new MobEffectInstance(EffectRegistry.RAPIDFIRE, 120 + AscendancyAbilities.getAscendancyPoints(player), 0, false, false, true));
        return true;
    }

    public static boolean cataclysm(Player player) {
        SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:cataclysm", 3, (Entity)player, null);
        player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.ENERGY_CHARGE, SoundSource.PLAYERS, 0.3f, 1.0f);
        return true;
    }

    public static boolean ghostwalk(Player player) {
        SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:ghostwalk", 3, (Entity)player, null);
        return true;
    }

    public static boolean skywardSunder(Player player) {
        player.m_7292_(new MobEffectInstance(EffectRegistry.SKYWARDSUNDER, 45, 0, false, false, true));
        player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SLASH_02, SoundSource.PLAYERS, 0.6f, 1.0f);
        return true;
    }

    public static void goldenAegis(Player player) {
        HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.GOLDENAEGIS, 2400, 1, 15 + AscendancyAbilities.getAscendancyPoints(player) / 10);
    }

    public static boolean righteousShield(Player player) {
        if (player.m_21023_(EffectRegistry.GOLDENAEGIS)) {
            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:righteous_shield", 3, (Entity)player, null);
            return true;
        }
        return false;
    }

    public static boolean chainbreaker(Player player) {
        HelperMethods.buffSteal((LivingEntity)player, (LivingEntity)player, true, false, true, true);
        player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SPELL_ARCANE_CAST, SoundSource.PLAYERS, 0.3f, 1.1f);
        HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.MIGHT, 120, 1 + AscendancyAbilities.getAscendancyPoints(player) / 10, 19);
        HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.MARKSMANSHIP, 120, 1 + AscendancyAbilities.getAscendancyPoints(player) / 10, 19);
        HelperMethods.spawnParticlesPlane(player.m_9236_(), (ParticleOptions)ParticleTypes.f_123759_, player.m_20183_(), 1, 0.0, 0.1, 0.0);
        if (AscendancyAbilities.getAscendancyPoints(player) > 29) {
            player.m_7292_(new MobEffectInstance(EffectRegistry.UNDYING, 120, 0, false, false, true));
        }
        return true;
    }
}

