/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsGemEffects;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class BerserkerAbilities {
    public static void passiveBerserkerSwordMastery(Player player) {
        int frequency = SimplySkills.berserkerConfig.passiveBerserkerSwordMasteryFrequency;
        int baseSpeedAmplifier = SimplySkills.berserkerConfig.passiveBerserkerSwordMasteryBaseSpeedAmplifier;
        int speedAmplifierPerTier = SimplySkills.berserkerConfig.passiveBerserkerSwordMasterySpeedAmplifierPerTier;
        if (player.f_19797_ % frequency == 0 && player.m_21205_() != null && player.m_21205_().m_41720_() instanceof SwordItem && !HelperMethods.stringContainsAny(player.m_21205_().m_41720_().m_41466_().toString(), new String[]{"Axe", "axe", "molten_edge", "livyatan", "soulpyre"})) {
            int mastery = baseSpeedAmplifier;
            if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerSwordMasterySkilled, (LivingEntity)player) && player.m_21206_().m_41619_()) {
                player.m_7292_(new MobEffectInstance(EffectRegistry.MIGHT, frequency + 5, 0, false, false, true));
            }
            if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerSwordMasteryProficient, (LivingEntity)player)) {
                mastery += speedAmplifierPerTier;
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, frequency + 5, mastery, false, false, true));
        }
    }

    public static void passiveBerserkerAxeMastery(Player player) {
        int frequency = SimplySkills.berserkerConfig.passiveBerserkerAxeMasteryFrequency;
        int baseStrengthAmplifier = SimplySkills.berserkerConfig.passiveBerserkerAxeMasteryBaseStrengthAmplifier;
        int strengthAmplifierPerTier = SimplySkills.berserkerConfig.passiveBerserkerAxeMasteryStrengthAmplifierPerTier;
        if (player.f_19797_ % frequency == 0 && player.m_21205_() != null && (player.m_21205_().m_41720_() instanceof AxeItem || HelperMethods.stringContainsAny(player.m_21205_().m_41720_().m_41466_().toString(), new String[]{"Axe", "axe", "molten_edge", "livyatan", "soulpyre"}))) {
            int mastery = baseStrengthAmplifier;
            if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerAxeMasterySkilled, (LivingEntity)player)) {
                mastery += strengthAmplifierPerTier * 2;
            } else if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerAxeMasteryProficient, (LivingEntity)player)) {
                mastery += strengthAmplifierPerTier;
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, frequency + 5, mastery, false, false, true));
        }
    }

    public static void passiveBerserkerIgnorePain(Player player) {
        int frequency = SimplySkills.berserkerConfig.passiveBerserkerIgnorePainFrequency;
        double healthThreshold = SimplySkills.berserkerConfig.passiveBerserkerIgnorePainHealthThreshold;
        int baseResistanceAmplifier = SimplySkills.berserkerConfig.passiveBerserkerIgnorePainBaseResistanceAmplifier;
        int resistanceAmplifierPerTier = SimplySkills.berserkerConfig.passiveBerserkerIgnorePainResistanceAmplifierPerTier;
        if (player.f_19797_ % frequency == 0) {
            int resistanceStacks = baseResistanceAmplifier;
            if ((double)player.m_21223_() <= healthThreshold * (double)player.m_21233_()) {
                if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerIgnorePainSkilled, (LivingEntity)player)) {
                    resistanceStacks += resistanceAmplifierPerTier * 2;
                } else if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerIgnorePainProficient, (LivingEntity)player)) {
                    resistanceStacks += resistanceAmplifierPerTier;
                }
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, frequency + 5, resistanceStacks, false, false, true));
            }
        }
    }

    public static void passiveBerserkerRecklessness(Player player) {
        int frequency = SimplySkills.berserkerConfig.passiveBerserkerRecklessnessFrequency;
        double healthThreshold = SimplySkills.berserkerConfig.passiveBerserkerRecklessnessHealthThreshold;
        int weaknessAmplifier = SimplySkills.berserkerConfig.passiveBerserkerRecklessnessWeaknessAmplifier;
        if (player.f_19797_ % frequency == 0 && (double)player.m_21223_() >= healthThreshold * (double)player.m_21233_()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, frequency + 5, weaknessAmplifier, false, false, true));
        }
    }

    public static void passiveBerserkerChallenge(Player player) {
        int frequency = SimplySkills.berserkerConfig.passiveBerserkerChallengeFrequency;
        int radius = SimplySkills.berserkerConfig.passiveBerserkerChallengeRadius;
        int count = 0;
        int countMax = SimplySkills.berserkerConfig.passiveBerserkerChallengeMaxAmplifier;
        if (player.f_19797_ % frequency == 0) {
            AABB box = HelperMethods.createBox((Entity)player, radius);
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                ++count;
            }
            if (count > countMax) {
                count = countMax;
            }
            if (count > 1) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, frequency + 5, count - 1, false, false, true));
            }
        }
    }

    public static void passiveBerserkerExploit(Entity target) {
        LivingEntity livingTarget;
        if (target instanceof LivingEntity && (livingTarget = (LivingEntity)target).m_21023_(EffectRegistry.IMMOBILIZE)) {
            livingTarget.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 120, 1, false, false, true));
        }
    }

    public static boolean signatureBerserkerRampage(String berserkerSkillTree, Player player) {
        int rampageDuration = SimplySkills.berserkerConfig.signatureBerserkerRampageDuration;
        int bullrushDuration = SimplySkills.berserkerConfig.signatureBerserkerBullrushDuration;
        player.m_7292_(new MobEffectInstance(EffectRegistry.RAMPAGE, rampageDuration, 0, false, false, true));
        if (HelperMethods.isUnlocked(berserkerSkillTree, SkillReferencePosition.berserkerSpecialisationRampageCharge, (LivingEntity)player)) {
            player.m_7292_(new MobEffectInstance(EffectRegistry.BULLRUSH, bullrushDuration, 0, false, false, true));
            player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SOUNDEFFECT15, SoundSource.PLAYERS, 0.5f, 1.1f);
        }
        return true;
    }

    public static boolean signatureBerserkerBloodthirsty(String berserkerSkillTree, Player player) {
        int bloodthirstyDuration = SimplySkills.berserkerConfig.signatureBerserkerBloodthirstyDuration;
        int bloodthirstyMightyStacks = SimplySkills.berserkerConfig.signatureBerserkerBloodthirstyMightyStacks;
        player.m_7292_(new MobEffectInstance(EffectRegistry.BLOODTHIRSTY, bloodthirstyDuration, 0, false, false, true));
        if (HelperMethods.isUnlocked(berserkerSkillTree, SkillReferencePosition.berserkerSpecialisationBloodthirstyMighty, (LivingEntity)player)) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.MIGHT, bloodthirstyDuration, bloodthirstyMightyStacks, 5);
        }
        return true;
    }

    public static boolean signatureBerserkerBerserking(String berserkerSkillTree, Player player) {
        double sacrificeAmountModifier = SimplySkills.berserkerConfig.signatureBerserkerBerserkingSacrificeAmount;
        int secondsPerSacrifice = SimplySkills.berserkerConfig.signatureBerserkerBerserkingSecondsPerSacrifice;
        int leapSlamDuration = SimplySkills.berserkerConfig.signatureBerserkerLeapSlamDuration;
        float sacrificeAmount = (float)((double)player.m_21223_() * sacrificeAmountModifier);
        if (!FabricLoader.getInstance().isModLoaded("simplyswords") || !SimplySwordsGemEffects.doSignatureGemEffects(player, "accelerant")) {
            player.m_6469_(player.m_269291_().m_269264_(), sacrificeAmount);
            player.m_7292_(new MobEffectInstance(EffectRegistry.BERSERKING, (int)(sacrificeAmount * (float)secondsPerSacrifice * 20.0f), 0, false, false, true));
        }
        if (HelperMethods.isUnlocked(berserkerSkillTree, SkillReferencePosition.berserkerSpecialisationBerserkingLeap, (LivingEntity)player)) {
            player.m_7292_(new MobEffectInstance(EffectRegistry.LEAPSLAM, leapSlamDuration, 0, false, false, true));
            player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SOUNDEFFECT15, SoundSource.PLAYERS, 0.5f, 1.1f);
        }
        return true;
    }
}

