/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.paladins.effect.Effects;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.effects.instance.SimplyStatusEffectInstance;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class CrusaderAbilities {
    public static void passiveCrusaderRetribution(Player player, LivingEntity attacker) {
        int retributionChance;
        int random = new Random().nextInt(100);
        if (random < (retributionChance = SimplySkills.crusaderConfig.passiveCrusaderRetributionChance)) {
            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:paladins_judgement", 32, (Entity)attacker, null);
        }
    }

    public static void passiveCrusaderExhaustiveRecovery(Player player, LivingEntity attacker) {
        int random = new Random().nextInt(100);
        int recoveryChance = SimplySkills.crusaderConfig.passiveCrusaderExhaustiveRecoveryChance;
        int exhaustStacks = SimplySkills.crusaderConfig.passiveCrusaderExhaustiveRecoveryExhaustionStacks - 1;
        if (random < recoveryChance) {
            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:paladins_flash_heal", 32, (Entity)player, null);
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.EXHAUSTION, 300, exhaustStacks, 99);
        }
    }

    public static void passiveCrusaderAegis(Player player) {
        int frequency = SimplySkills.crusaderConfig.passiveCrusaderAegisFrequency;
        int stacksRemoved = SimplySkills.crusaderConfig.passiveCrusaderAegisStacksRemoved;
        if (player.m_21023_(EffectRegistry.EXHAUSTION) && player.f_19797_ % frequency == 0 && player.m_21124_(EffectRegistry.EXHAUSTION).m_19564_() > stacksRemoved) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, Effects.DIVINE_PROTECTION, 200, 1, 5);
            HelperMethods.decrementStatusEffects((LivingEntity)player, EffectRegistry.EXHAUSTION, stacksRemoved);
        }
    }

    public static boolean signatureHeavensmithsCall(String crusaderSkillTree, Player player) {
        BlockPos blockpos = null;
        Entity target = null;
        boolean success = false;
        int heavensmithsCallRange = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallRange;
        int duration = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallDADuration;
        if (HelperMethods.getTargetedEntity((Entity)player, heavensmithsCallRange) != null) {
            blockpos = HelperMethods.getTargetedEntity((Entity)player, heavensmithsCallRange).m_20183_();
        }
        if (blockpos == null) {
            blockpos = HelperMethods.getBlockLookingAt(player, heavensmithsCallRange);
        }
        if (blockpos != null) {
            LivingEntity le;
            if (target instanceof LivingEntity && !HelperMethods.checkFriendlyFire(le = (LivingEntity)target, player)) {
                target = null;
            }
            if (HelperMethods.isUnlocked(crusaderSkillTree, SkillReferencePosition.crusaderSpecialisationDivineAdjudication, (LivingEntity)player)) {
                player.m_7292_(new MobEffectInstance(EffectRegistry.DIVINEADJUDICATION, duration, 0, false, false, true));
            }
            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:physical_heavensmiths_call", heavensmithsCallRange, target, blockpos);
            success = true;
        }
        return success;
    }

    public static void signatureHeavensmithsCallImpact(String crusaderSkillTree, List<Entity> targets, ResourceLocation spellId, Player player) {
        int tauntDuration = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallTauntMarkDuration;
        if (spellId != null && spellId.toString().equals("simplyskills:physical_heavensmiths_call")) {
            Entity target = targets.get(0);
            AABB box = HelperMethods.createBox(target, 3);
            for (Entity entities : target.m_9236_().m_6249_(target, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (!(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                if (HelperMethods.isUnlocked(crusaderSkillTree, SkillReferencePosition.crusaderSpecialisationHeavensmithsCallMark, (LivingEntity)player)) {
                    le.m_7292_(new MobEffectInstance(EffectRegistry.DEATHMARK, tauntDuration));
                }
                if (!(le instanceof Mob)) continue;
                Mob me = (Mob)le;
                if (!HelperMethods.isUnlocked(crusaderSkillTree, SkillReferencePosition.crusaderSpecialisationHeavensmithsCallTaunt, (LivingEntity)player)) continue;
                SimplyStatusEffectInstance tauntEffect = new SimplyStatusEffectInstance(EffectRegistry.TAUNTED, tauntDuration, 0, false, false, true);
                tauntEffect.setSourceEntity((LivingEntity)player);
                me.m_7292_((MobEffectInstance)tauntEffect);
            }
        }
    }

    public static boolean signatureCrusaderSacredOnslaught(String crusaderSkillTree, Player player) {
        int divineProtectionDuration = SimplySkills.crusaderConfig.signatureCrusaderSacredOnslaughtDPDuration;
        int dashDuration = SimplySkills.crusaderConfig.signatureCrusaderSacredOnslaughtDashDuration;
        player.m_7292_(new MobEffectInstance(EffectRegistry.SACREDONSLAUGHT, dashDuration, 0, false, false, true));
        if (HelperMethods.isUnlocked(crusaderSkillTree, SkillReferencePosition.crusaderSpecialisationSacredOnslaughtDefend, (LivingEntity)player)) {
            player.m_7292_(new MobEffectInstance(Effects.DIVINE_PROTECTION, divineProtectionDuration, 0, false, false, true));
            player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SOUNDEFFECT15, SoundSource.PLAYERS, 0.5f, 1.1f);
        }
        if (HelperMethods.isUnlocked(crusaderSkillTree, SkillReferencePosition.crusaderSpecialisationSacredOnslaughtMighty, (LivingEntity)player)) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.MIGHT, divineProtectionDuration, 3, 5);
        }
        return true;
    }

    public static boolean signatureCrusaderConsecration(String crusaderSkillTree, Player player) {
        int consecrationExtendDuration = SimplySkills.crusaderConfig.signatureCrusaderConsecrationExtendDuration;
        int consecrationDuration = SimplySkills.crusaderConfig.signatureCrusaderConsecrationDuration;
        if (HelperMethods.isUnlocked(crusaderSkillTree, SkillReferencePosition.crusaderSpecialisationConsecrationDuration, (LivingEntity)player)) {
            consecrationDuration = SimplySkills.crusaderConfig.signatureCrusaderConsecrationDuration + consecrationExtendDuration;
        }
        player.m_7292_(new MobEffectInstance(EffectRegistry.CONSECRATION, consecrationDuration, 0, false, false, true));
        return true;
    }

    public static void effectDivineAdjudication(Player player) {
        int frequency = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallDAFrequency;
        if (HelperMethods.isUnlocked("simplyskills:crusader", SkillReferencePosition.crusaderSpecialisationHeavensmithsCall, (LivingEntity)player) && player.m_21023_(EffectRegistry.DIVINEADJUDICATION) && player.f_19797_ % frequency == 0) {
            int chance = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallDAChance;
            int radius = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallDARadius;
            int exhaustStacksRemoved = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallDAExhaustStacks;
            int mightDuration = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallDAMightDuration;
            int mightStacksMax = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallDAMightStacksMax - 1;
            String spellIdentifier = "simplyskills:paladins_judgement";
            if (SignatureAbilities.castSpellEngineAOE(player, spellIdentifier, radius, chance, true, false)) {
                if (HelperMethods.isUnlocked("simplyskills:crusader", SkillReferencePosition.crusaderSpecialisationHeavensmithsCallExhaust, (LivingEntity)player)) {
                    HelperMethods.decrementStatusEffects((LivingEntity)player, EffectRegistry.EXHAUSTION, exhaustStacksRemoved);
                }
                if (HelperMethods.isUnlocked("simplyskills:crusader", SkillReferencePosition.crusaderSpecialisationHeavensmithsCallMighty, (LivingEntity)player)) {
                    HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.MIGHT, mightDuration, 1, mightStacksMax);
                }
            }
        }
    }
}

