/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;
import org.jetbrains.annotations.Nullable;

public class InitiateAbilities {
    public static void passiveInitiateNullification(Player player) {
        int nullificationFrequency = SimplySkills.initiateConfig.passiveInitiateNullificationFrequency;
        int radius = SimplySkills.initiateConfig.passiveInitiateNullificationRadius;
        if (player.f_19797_ % nullificationFrequency == 0) {
            AABB box = HelperMethods.createBox((Entity)player, radius);
            block0: for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                for (MobEffectInstance statusEffect : le.m_21220_()) {
                    if (statusEffect == null || !statusEffect.m_19544_().m_19486_()) continue;
                    HelperMethods.decrementStatusEffect(le, statusEffect.m_19544_());
                    continue block0;
                }
            }
        }
    }

    public static void passiveInitiateEmpower(Player player, @Nullable SpellSchool school, @Nullable Set<? extends SpellSchool> schools) {
        int chance = SimplySkills.initiateConfig.passiveInitiateEmpowerChance;
        int duration = SimplySkills.initiateConfig.passiveInitiateEmpowerDuration;
        int amplifier = SimplySkills.initiateConfig.passiveInitiateEmpowerStacks;
        int amplifierMax = SimplySkills.initiateConfig.passiveInitiateEmpowerMaxStacks;
        ArrayList<MobEffect> list = new ArrayList<MobEffect>();
        if (school == SpellSchools.ARCANE || schools != null && schools.contains(SpellSchools.ARCANE)) {
            list.add(EffectRegistry.ARCANEATTUNEMENT);
        }
        if (school == SpellSchools.SOUL || schools != null && schools.contains(SpellSchools.SOUL)) {
            list.add(EffectRegistry.SOULATTUNEMENT);
        }
        if (school == SpellSchools.HEALING || schools != null && schools.contains(SpellSchools.HEALING)) {
            list.add(EffectRegistry.HOLYATTUNEMENT);
        }
        if (school == SpellSchools.FIRE || schools != null && schools.contains(SpellSchools.FIRE)) {
            list.add(EffectRegistry.FIREATTUNEMENT);
        }
        if (school == SpellSchools.FROST || schools != null && schools.contains(SpellSchools.FROST)) {
            list.add(EffectRegistry.FROSTATTUNEMENT);
        }
        if (school == SpellSchools.LIGHTNING || schools != null && schools.contains(SpellSchools.LIGHTNING)) {
            list.add(EffectRegistry.LIGHTNINGATTUNEMENT);
        }
        if (!list.isEmpty()) {
            int random = player.m_217043_().m_188503_(100);
            if (random < chance) {
                random = player.m_217043_().m_188503_(list.size());
                MobEffect chosenEffect = (MobEffect)list.get(random);
                HelperMethods.incrementStatusEffect((LivingEntity)player, chosenEffect, duration, amplifier, amplifierMax);
            }
            if (player.m_21023_((MobEffect)list.get(0)) && HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateAttuned, (LivingEntity)player)) {
                int stackThreshold = SimplySkills.initiateConfig.passiveInitiateAttunedStackThreshold - 1;
                MobEffectInstance statusInstance = player.m_21124_((MobEffect)list.get(0));
                if (statusInstance != null && statusInstance.m_19564_() > stackThreshold) {
                    InitiateAbilities.passiveInitiateAttuned(player, statusInstance);
                }
            }
        }
    }

    public static void passiveInitiateAttuned(Player player, MobEffectInstance statusInstance) {
        int duration = SimplySkills.initiateConfig.passiveInitiateAttunedDuration;
        int stacks = SimplySkills.initiateConfig.passiveInitiateAttunedStacks;
        int maxStacks = SimplySkills.initiateConfig.passiveInitiateAttunedMaxStacks;
        int frequency = SimplySkills.initiateConfig.passiveInitiateAttunedFrequency;
        if (player.f_19797_ % frequency == 0) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.PRECISION, duration, stacks, maxStacks);
            HelperMethods.decrementStatusEffect((LivingEntity)player, statusInstance.m_19544_());
        }
    }

    public static void passiveInitiateLightningRod(Player player) {
        int duration = SimplySkills.initiateConfig.passiveInitiateLightningRodDuration;
        int stacks = SimplySkills.initiateConfig.passiveInitiateLightningRodStacks;
        int maxStacks = SimplySkills.initiateConfig.passiveInitiateLightningRodMaxStacks;
        int frequency = SimplySkills.initiateConfig.passiveInitiateLightningRodFrequency;
        if (player.f_19797_ % frequency == 0 && player.m_9236_().m_46470_()) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.LIGHTNINGATTUNEMENT, duration, stacks, maxStacks);
        }
    }

    public static void passiveInitiateHasty(Player player) {
        int duration = SimplySkills.initiateConfig.passiveInitiateHastyDuration;
        int stacks = SimplySkills.initiateConfig.passiveInitiateHastyStacks;
        HelperMethods.incrementStatusEffect((LivingEntity)player, MobEffects.f_19597_, duration, stacks, 4);
    }

    public static void passiveInitiateFrail(Player player) {
        int attackThreshold = SimplySkills.initiateConfig.passiveInitiateFrailAttackThreshold;
        int weaknessAmplifier = SimplySkills.initiateConfig.passiveInitiateFrailWeaknessAmplifier;
        int miningFatigueAmplifier = SimplySkills.initiateConfig.passiveInitiateFrailMiningFatigueAmplifier;
        if (HelperMethods.getAttackDamage(player.m_21205_()) > (double)attackThreshold || HelperMethods.getAttackDamage(player.m_21206_()) > (double)attackThreshold && HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wayfarerSlender, (LivingEntity)player)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 25, weaknessAmplifier, false, false, true));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 25, miningFatigueAmplifier, false, false, true));
        }
    }

    public static void passiveInitiateEldritchEnfeeblement(Player player, List<Entity> targets) {
        if (targets.isEmpty()) {
            return;
        }
        double critDamage = 0.0;
        double critChance = 0.0;
        if (BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation("spell_power:critical_chance")) != null) {
            critChance = player.m_21133_((Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation("spell_power:critical_chance")));
        }
        if (BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation("spell_power:critical_damage")) != null) {
            critDamage = player.m_21133_((Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation("spell_power:critical_damage")));
        }
        if ((double)player.m_217043_().m_188503_(100) < critChance) {
            player.m_5634_((float)Math.min(3.0, critDamage / 100.0));
        }
    }

    public static void passiveInitiatePerilousPrecision(Player player, List<Entity> targets) {
        if (targets.isEmpty()) {
            return;
        }
        int chance = Math.max(1, 50 - (int)player.m_21133_(Attributes.f_22276_));
        if (player.m_217043_().m_188503_(100) < chance) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.BARRIER, 60, 1, 10);
        }
    }
}

