/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.Random;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.phys.AABB;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellHelper;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsGemEffects;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class RogueAbilities {
    public static void passiveRogueBackstab(Entity target, Player player) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            int weaknessDuration = SimplySkills.rogueConfig.passiveRogueBackstabWeaknessDuration;
            int weaknessAmplifier = SimplySkills.rogueConfig.passiveRogueBackstabWeaknessAmplifier;
            if (livingTarget.m_213816_() < player.m_213816_() + 32.0f && livingTarget.m_213816_() > player.m_213816_() - 32.0f) {
                livingTarget.m_7292_(new MobEffectInstance(MobEffects.f_19613_, weaknessDuration, weaknessAmplifier, false, false, true));
            }
        }
    }

    public static void passiveRogueSmokeBomb(Player player) {
        int radius = SimplySkills.rogueConfig.passiveRogueSmokeBombRadius;
        int chance = SimplySkills.rogueConfig.passiveRogueSmokeBombChance;
        int auraDuration = SimplySkills.rogueConfig.passiveRogueSmokeBombAuraDuration;
        int blindnessDuration = SimplySkills.rogueConfig.passiveRogueSmokeBombBlindnessDuration;
        int blindnessAmplifier = SimplySkills.rogueConfig.passiveRogueSmokeBombBlindnessAmplifier;
        if (player.m_217043_().m_188503_(100) < chance) {
            AABB box = HelperMethods.createBox((Entity)player, radius);
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                le.m_7292_(new MobEffectInstance(MobEffects.f_19610_, blindnessDuration, blindnessAmplifier, false, false, true));
            }
            player.m_7292_(new MobEffectInstance(EffectRegistry.IMMOBILIZINGAURA, auraDuration, 0, false, false, true));
            player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SOUNDEFFECT32, SoundSource.PLAYERS, 0.4f, 1.2f);
        }
    }

    public static boolean passiveRogueEvasionMastery(Player player) {
        int baseEvasionChance = SimplySkills.rogueConfig.passiveRogueEvasionMasteryChance;
        int extraEvasionChance = SimplySkills.rogueConfig.passiveRogueDeflectionIncreasedChance;
        int evasionChanceIncreasePerTier = SimplySkills.rogueConfig.passiveRogueEvasionMasteryChanceIncreasePerTier;
        int masteryEvasionMultiplier = SimplySkills.rogueConfig.passiveRogueEvasionMasterySignatureMultiplier;
        int mastery = 0;
        mastery = HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueDeflection, (LivingEntity)player) && player.m_21205_().m_41720_() instanceof SwordItem && player.m_21206_().m_41720_() instanceof SwordItem ? baseEvasionChance + extraEvasionChance : baseEvasionChance;
        int evasionMultiplier = 1;
        if (player.m_21023_(EffectRegistry.EVASION)) {
            evasionMultiplier = masteryEvasionMultiplier;
        }
        if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueEvasionMasterySkilled, (LivingEntity)player)) {
            mastery += evasionChanceIncreasePerTier * 2;
        } else if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueEvasionMasteryProficient, (LivingEntity)player)) {
            mastery += evasionChanceIncreasePerTier;
        }
        MobEffectInstance statusEffect = player.m_21124_(EffectRegistry.BLADESTORM);
        if (statusEffect != null) {
            mastery += statusEffect.m_19564_() + 1;
        }
        if (player.m_217043_().m_188503_(100) < mastery * evasionMultiplier && player.m_21023_(EffectRegistry.AGILE)) {
            if (FabricLoader.getInstance().isModLoaded("simplyswords")) {
                SimplySwordsGemEffects.deception(player);
            }
            player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.FX_SKILL_BACKSTAB, SoundSource.PLAYERS, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    public static void passiveRogueOpportunisticMastery(Entity target, Player player) {
        int basePoisonDuration = SimplySkills.rogueConfig.passiveRogueOpportunisticMasteryPoisonDuration;
        int basePoisonAmplifier = SimplySkills.rogueConfig.passiveRogueOpportunisticMasteryPoisonAmplifier;
        int poisonDurationIncreasePerTier = SimplySkills.rogueConfig.passiveRogueOpportunisticMasteryPoisonDurationIncreasePerTier;
        int mastery = basePoisonDuration;
        if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueOpportunisticMasterySkilled, (LivingEntity)player)) {
            mastery += poisonDurationIncreasePerTier * 2;
        } else if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueOpportunisticMasteryProficient, (LivingEntity)player)) {
            mastery += poisonDurationIncreasePerTier;
        }
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.m_7292_(new MobEffectInstance(MobEffects.f_19614_, mastery, basePoisonAmplifier, false, false, true));
        }
    }

    public static void passiveRogueBackstabStealth(Player player) {
        int stealthChance = SimplySkills.rogueConfig.passiveRogueBackstabStealthChancePerEnemy;
        int stealthDuration = SimplySkills.rogueConfig.passiveRogueBackstabStealthDuration;
        if (player.f_19797_ % 20 == 0) {
            AABB box = HelperMethods.createBox((Entity)player, 8);
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null || !(entities instanceof LivingEntity) || !(le = (LivingEntity)entities).m_21023_(MobEffects.f_19613_) || !HelperMethods.checkFriendlyFire(le, player) || player.m_217043_().m_188503_(100) >= stealthChance) continue;
                player.m_7292_(new MobEffectInstance(EffectRegistry.STEALTH, stealthDuration, 0, false, false, true));
                player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SOUNDEFFECT39, SoundSource.PLAYERS, 0.6f, 1.6f);
            }
        }
    }

    public static void passiveRoguePreparationShadowstrike(Player player) {
        if (player instanceof ServerPlayer && HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueSpecialisationPreparationShadowstrike, (LivingEntity)player)) {
            int dashRange = SimplySkills.rogueConfig.signatureRoguePreparationShadowstrikeRange;
            int dashRadius = SimplySkills.rogueConfig.signatureRoguePreparationShadowstrikeRadius;
            int dashDamageModifier = SimplySkills.rogueConfig.signatureRoguePreparationShadowstrikeDamageModifier;
            int dashDamage = (int)player.m_21133_(Attributes.f_22281_);
            DamageSource dashSource = player.m_9236_().m_269111_().m_269075_(player);
            BlockPos blockPos = player.m_20183_().m_5484_(player.m_6374_(), dashRange);
            AABB box = HelperMethods.createBoxBetween(player.m_20183_(), blockPos, dashRadius);
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                le.m_6469_(dashSource, (float)(dashDamage * dashDamageModifier));
                if (!HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueSpecialisationPreparationShadowstrikeVampire, (LivingEntity)player)) continue;
                HelperMethods.buffSteal((LivingEntity)player, le, true, true, false, false);
                le.m_7292_(new MobEffectInstance(EffectRegistry.DEATHMARK, 120, 0, false, false, true));
            }
            if (!player.m_20096_()) {
                dashRange /= 5;
            }
            player.m_20256_(player.m_20154_().m_82490_((double)dashRange));
            player.m_20334_(player.m_20184_().f_82479_, 0.0, player.m_20184_().f_82481_);
            player.f_19864_ = true;
            player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SOUNDEFFECT15, SoundSource.PLAYERS, 0.6f, 1.3f);
        }
    }

    public static boolean signatureRogueEvasion(String rogueSkillTree, Player player) {
        int evasionDuration = SimplySkills.rogueConfig.signatureRogueEvasionDuration;
        int fanOfBladesDuration = SimplySkills.rogueConfig.signatureRogueFanOfBladesDuration;
        int fanOfBladesStacks = SimplySkills.rogueConfig.signatureRogueFanOfBladesStacks - 1;
        player.m_7292_(new MobEffectInstance(EffectRegistry.EVASION, evasionDuration, 0, false, false, true));
        if (HelperMethods.isUnlocked(rogueSkillTree, SkillReferencePosition.rogueSpecialisationEvasionFanOfBladesAssault, (LivingEntity)player)) {
            fanOfBladesStacks *= 2;
        }
        if (HelperMethods.isUnlocked(rogueSkillTree, SkillReferencePosition.rogueSpecialisationEvasionFanOfBlades, (LivingEntity)player)) {
            player.m_7292_(new MobEffectInstance(EffectRegistry.FANOFBLADES, fanOfBladesDuration, fanOfBladesStacks, false, false, true));
        }
        return true;
    }

    public static boolean signatureRoguePreparation(String rogueSkillTree, Player player) {
        int preparationDuration = SimplySkills.rogueConfig.signatureRoguePreparationDuration;
        int speedAmplifier = SimplySkills.rogueConfig.signatureRoguePreparationSpeedAmplifier;
        player.m_7292_(new MobEffectInstance(EffectRegistry.STEALTH, preparationDuration, 0, false, false, true));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, preparationDuration, speedAmplifier, false, false, true));
        if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueSpecialisationPreparationShadowstrikeShield, (LivingEntity)player)) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.BARRIER, 20, 0, 5);
            if (player.m_21023_(EffectRegistry.REVEALED)) {
                player.m_21195_(EffectRegistry.REVEALED);
            }
        }
        player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SOUNDEFFECT39, SoundSource.PLAYERS, 0.6f, 1.6f);
        if (HelperMethods.isUnlocked(rogueSkillTree, SkillReferencePosition.rogueSpecialisationPreparationShadowstrike, (LivingEntity)player)) {
            RogueAbilities.passiveRoguePreparationShadowstrike(player);
        }
        return true;
    }

    public static boolean signatureRogueSiphoningStrikes(String rogueSkillTree, Player player) {
        int siphoningStrikesduration = SimplySkills.rogueConfig.signatureRogueSiphoningStrikesDuration;
        int siphoningStrikesStacks = SimplySkills.rogueConfig.signatureRogueSiphoningStrikesStacks;
        int siphoningStrikesMightyStacks = SimplySkills.rogueConfig.signatureRogueSiphoningStrikesMightyStacks;
        player.m_7292_(new MobEffectInstance(EffectRegistry.SIPHONINGSTRIKES, siphoningStrikesduration, siphoningStrikesStacks, false, false, true));
        if (HelperMethods.isUnlocked(rogueSkillTree, SkillReferencePosition.rogueSpecialisationSiphoningStrikesMighty, (LivingEntity)player)) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.MIGHT, siphoningStrikesduration, siphoningStrikesMightyStacks, 5);
        }
        if (HelperMethods.isUnlocked(rogueSkillTree, SkillReferencePosition.rogueSpecialisationSiphoningStrikesAura, (LivingEntity)player)) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.IMMOBILIZINGAURA, siphoningStrikesduration, 1, 2);
        }
        return true;
    }

    public static void daggerstormSummon(Player player) {
        AABB box = HelperMethods.createBox((Entity)player, 8);
        int count = 12;
        int chance = 95;
        int location = -3;
        for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20402_)) {
            SpellProjectile spe;
            if (entities == null) continue;
            if (entities instanceof SpellProjectile && (spe = (SpellProjectile)entities).m_19749_() == player) {
                --count;
            }
            if (!(entities instanceof LivingEntity)) continue;
            LivingEntity le = (LivingEntity)entities;
            if (count <= 0 || player.m_217043_().m_188503_(100) >= chance || !HelperMethods.checkFriendlyFire(le, player)) continue;
            SpellHelper.ImpactContext context = new SpellHelper.ImpactContext();
            SpellProjectile projectile = new SpellProjectile(player.m_9236_(), (LivingEntity)player, player.m_20185_() + (double)location, player.m_20186_(), player.m_20189_() + (double)location, SpellProjectile.Behaviour.FLY, new ResourceLocation("simplyskills:physical_dagger_homing"), (Entity)null, context, null);
            Random random = new Random();
            projectile.m_20256_(player.m_20184_().m_82490_(5.0).m_82535_((float)random.nextInt(280)).m_82496_((float)random.nextInt(280)));
            projectile.range = 356.0f;
            ProjectileUtil.m_37284_((Entity)projectile, (float)0.2f);
            projectile.setFollowedTarget((Entity)le);
            player.m_9236_().m_7967_((Entity)projectile);
            ++location;
        }
    }
}

