/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_power.api.SpellPower;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.AscendancyAbilities;
import net.sweenus.simplyskills.abilities.BerserkerAbilities;
import net.sweenus.simplyskills.abilities.ClericAbilities;
import net.sweenus.simplyskills.abilities.CrusaderAbilities;
import net.sweenus.simplyskills.abilities.NecromancerAbilities;
import net.sweenus.simplyskills.abilities.ProminenceAbilities;
import net.sweenus.simplyskills.abilities.RangerAbilities;
import net.sweenus.simplyskills.abilities.RogueAbilities;
import net.sweenus.simplyskills.abilities.SpellbladeAbilities;
import net.sweenus.simplyskills.abilities.WizardAbilities;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsGemEffects;
import net.sweenus.simplyskills.network.CooldownPacket;
import net.sweenus.simplyskills.network.KeybindPacket;
import net.sweenus.simplyskills.registry.EntityRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;
import org.jetbrains.annotations.Nullable;

public class SignatureAbilities {
    public static void signatureAbilityManager(Player player, String abilityType) {
        String wizardSkillTree = "simplyskills:wizard";
        String berserkerSkillTree = "simplyskills:berserker";
        String rogueSkillTree = "simplyskills:rogue";
        String rangerSkillTree = "simplyskills:ranger";
        String spellbladeSkillTree = "simplyskills:spellblade";
        String crusaderSkillTree = "simplyskills:crusader";
        String clericSkillTree = "simplyskills:cleric";
        String necromancerSkillTree = "simplyskills:necromancer";
        String baseTree = "simplyskills:tree";
        String ascendancyTree = "simplyskills:ascendancy";
        boolean ability_success = false;
        String ability = "none";
        if (FabricLoader.getInstance().isModLoaded("prominent")) {
            ascendancyTree = "puffish_skills:prom";
        }
        if (abilityType.contains("signature")) {
            if (HelperMethods.isUnlocked(wizardSkillTree, null, (LivingEntity)player)) {
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationMeteorShower, (LivingEntity)player)) {
                    ability_success = WizardAbilities.signatureWizardMeteorShower(wizardSkillTree, player);
                    ability = "MeteorShower";
                }
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceComet, (LivingEntity)player)) {
                    ability_success = WizardAbilities.signatureWizardIceComet(wizardSkillTree, player);
                    ability = "IceComet";
                }
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischarge, (LivingEntity)player)) {
                    ability_success = WizardAbilities.signatureWizardStaticDischarge(wizardSkillTree, player);
                    ability = "StaticDischarge";
                }
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationArcaneBolt, (LivingEntity)player)) {
                    ability_success = WizardAbilities.signatureWizardArcaneBolt(wizardSkillTree, player);
                    ability = "ArcaneBolt";
                }
            }
            if (HelperMethods.isUnlocked(berserkerSkillTree, null, (LivingEntity)player)) {
                if (HelperMethods.isUnlocked(berserkerSkillTree, SkillReferencePosition.berserkerSpecialisationRampage, (LivingEntity)player)) {
                    ability_success = BerserkerAbilities.signatureBerserkerRampage(berserkerSkillTree, player);
                    ability = "Rampage";
                }
                if (HelperMethods.isUnlocked(berserkerSkillTree, SkillReferencePosition.berserkerSpecialisationBloodthirsty, (LivingEntity)player)) {
                    ability_success = BerserkerAbilities.signatureBerserkerBloodthirsty(berserkerSkillTree, player);
                    ability = "Bloodthirsty";
                }
                if (HelperMethods.isUnlocked(berserkerSkillTree, SkillReferencePosition.berserkerSpecialisationBerserking, (LivingEntity)player)) {
                    ability_success = BerserkerAbilities.signatureBerserkerBerserking(berserkerSkillTree, player);
                    ability = "Berserking";
                }
            }
            if (HelperMethods.isUnlocked(rogueSkillTree, null, (LivingEntity)player)) {
                if (HelperMethods.isUnlocked(rogueSkillTree, SkillReferencePosition.rogueSpecialisationEvasion, (LivingEntity)player)) {
                    ability_success = RogueAbilities.signatureRogueEvasion(rogueSkillTree, player);
                    ability = "Evasion";
                }
                if (HelperMethods.isUnlocked(rogueSkillTree, SkillReferencePosition.rogueSpecialisationPreparation, (LivingEntity)player)) {
                    ability_success = RogueAbilities.signatureRoguePreparation(rogueSkillTree, player);
                    ability = "Preparation";
                }
                if (HelperMethods.isUnlocked(rogueSkillTree, SkillReferencePosition.rogueSpecialisationSiphoningStrikes, (LivingEntity)player)) {
                    ability_success = RogueAbilities.signatureRogueSiphoningStrikes(rogueSkillTree, player);
                    ability = "SiphoningStrikes";
                }
            }
            if (HelperMethods.isUnlocked(rangerSkillTree, null, (LivingEntity)player)) {
                if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationElementalArrows, (LivingEntity)player)) {
                    ability_success = RangerAbilities.signatureRangerElementalArrows(rangerSkillTree, player);
                    ability = "ElementalArrows";
                }
                if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationDisengage, (LivingEntity)player)) {
                    ability_success = RangerAbilities.signatureRangerDisengage(rangerSkillTree, player);
                    ability = "Disengage";
                }
                if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationArrowRain, (LivingEntity)player)) {
                    ability_success = RangerAbilities.signatureRangerArrowRain(rangerSkillTree, player);
                    ability = "ArrowRain";
                }
            }
            if (HelperMethods.isUnlocked(spellbladeSkillTree, null, (LivingEntity)player)) {
                if (HelperMethods.isUnlocked(spellbladeSkillTree, SkillReferencePosition.spellbladeSpecialisationElementalSurge, (LivingEntity)player)) {
                    ability_success = SpellbladeAbilities.signatureSpellbladeElementalSurge(spellbladeSkillTree, player);
                    ability = "ElementalSurge";
                }
                if (HelperMethods.isUnlocked(spellbladeSkillTree, SkillReferencePosition.spellbladeSpecialisationElementalImpact, (LivingEntity)player)) {
                    ability_success = SpellbladeAbilities.signatureSpellbladeElementalImpact(spellbladeSkillTree, player);
                    ability = "ElementalImpact";
                }
                if (HelperMethods.isUnlocked(spellbladeSkillTree, SkillReferencePosition.spellbladeSpecialisationSpellweaver, (LivingEntity)player)) {
                    ability_success = SpellbladeAbilities.signatureSpellbladeSpellweaver(spellbladeSkillTree, player);
                    ability = "Spellweaver";
                }
            }
            if (HelperMethods.isUnlocked(crusaderSkillTree, null, (LivingEntity)player) && FabricLoader.getInstance().isModLoaded("paladins")) {
                if (HelperMethods.isUnlocked(crusaderSkillTree, SkillReferencePosition.crusaderSpecialisationHeavensmithsCall, (LivingEntity)player)) {
                    ability_success = CrusaderAbilities.signatureHeavensmithsCall(crusaderSkillTree, player);
                    ability = "HeavensmithsCall";
                }
                if (HelperMethods.isUnlocked(crusaderSkillTree, SkillReferencePosition.crusaderSpecialisationSacredOnslaught, (LivingEntity)player)) {
                    ability_success = CrusaderAbilities.signatureCrusaderSacredOnslaught(crusaderSkillTree, player);
                    ability = "SacredOnslaught";
                }
                if (HelperMethods.isUnlocked(crusaderSkillTree, SkillReferencePosition.crusaderSpecialisationConsecration, (LivingEntity)player)) {
                    ability_success = CrusaderAbilities.signatureCrusaderConsecration(crusaderSkillTree, player);
                    ability = "Consecration";
                }
            }
            if (HelperMethods.isUnlocked(clericSkillTree, null, (LivingEntity)player) && FabricLoader.getInstance().isModLoaded("paladins")) {
                if (HelperMethods.isUnlocked(clericSkillTree, SkillReferencePosition.clericSpecialisationDivineIntervention, (LivingEntity)player)) {
                    ability_success = ClericAbilities.signatureClericDivineIntervention(clericSkillTree, player);
                    ability = "DivineIntervention";
                }
                if (HelperMethods.isUnlocked(clericSkillTree, SkillReferencePosition.clericSpecialisationSacredOrb, (LivingEntity)player)) {
                    ability_success = ClericAbilities.signatureClericSacredOrb(clericSkillTree, player);
                    ability = "SacredOrb";
                }
                if (HelperMethods.isUnlocked(clericSkillTree, SkillReferencePosition.clericSpecialisationAnointWeapon, (LivingEntity)player)) {
                    ability_success = ClericAbilities.signatureClericAnointWeapon(player);
                    ability = "AnointWeapon";
                }
            }
            if (HelperMethods.isUnlocked(necromancerSkillTree, null, (LivingEntity)player) && HelperMethods.isUnlocked(necromancerSkillTree, SkillReferencePosition.necromancerSpecialisationSummoningRitual, (LivingEntity)player)) {
                ability_success = NecromancerAbilities.signatureNecromancerSummoningRitual(necromancerSkillTree, player);
                ability = "SummoningRitual";
            }
        } else if (abilityType.contains("ascendancy") && HelperMethods.isUnlocked(ascendancyTree, null, (LivingEntity)player)) {
            if (HelperMethods.isUnlocked(ascendancyTree, SkillReferencePosition.ascendancyRighteousHammers, (LivingEntity)player)) {
                ability_success = AscendancyAbilities.righteousHammers(player);
                ability = "RighteousHammers";
            }
            if (HelperMethods.isUnlocked(ascendancyTree, SkillReferencePosition.ascendancyBoneArmor, (LivingEntity)player)) {
                ability_success = FabricLoader.getInstance().isModLoaded("prominent") ? ProminenceAbilities.boneArmor(player) : AscendancyAbilities.boneArmor(player);
                ability = "BoneArmor";
            }
            if (HelperMethods.isUnlocked(ascendancyTree, SkillReferencePosition.ascendancyCyclonicCleave, (LivingEntity)player)) {
                ability_success = AscendancyAbilities.cyclonicCleave(player);
                ability = "CyclonicCleave";
            }
            if (HelperMethods.isUnlocked(ascendancyTree, SkillReferencePosition.ascendancyMagicCircle, (LivingEntity)player)) {
                ability_success = AscendancyAbilities.magicCircle(player);
                ability = "MagicCircle";
            }
            if (HelperMethods.isUnlocked(ascendancyTree, SkillReferencePosition.ascendancyArcaneSlash, (LivingEntity)player)) {
                ability_success = AscendancyAbilities.arcaneSlash(player);
                ability = "ArcaneSlash";
            }
            if (HelperMethods.isUnlocked(ascendancyTree, SkillReferencePosition.ascendancyAgony, (LivingEntity)player)) {
                ability_success = AscendancyAbilities.agony(player);
                ability = "Agony";
            }
            if (HelperMethods.isUnlocked(ascendancyTree, SkillReferencePosition.ascendancyTorment, (LivingEntity)player)) {
                ability_success = AscendancyAbilities.torment(player);
                ability = "Torment";
            }
            if (HelperMethods.isUnlocked(ascendancyTree, SkillReferencePosition.ascendancyRapidfire, (LivingEntity)player)) {
                ability_success = AscendancyAbilities.rapidfire(player);
                ability = "Rapidfire";
            }
            if (HelperMethods.isUnlocked(ascendancyTree, SkillReferencePosition.ascendancyCataclysm, (LivingEntity)player)) {
                ability_success = AscendancyAbilities.cataclysm(player);
                ability = "Cataclysm";
            }
            if (HelperMethods.isUnlocked(ascendancyTree, SkillReferencePosition.ascendancyGhostwalk, (LivingEntity)player)) {
                ability_success = AscendancyAbilities.ghostwalk(player);
                ability = "Ghostwalk";
            }
            if (HelperMethods.isUnlocked(ascendancyTree, SkillReferencePosition.ascendancySkywardSunder, (LivingEntity)player)) {
                ability_success = AscendancyAbilities.skywardSunder(player);
                ability = "SkywardSunder";
            }
            if (HelperMethods.isUnlocked(ascendancyTree, SkillReferencePosition.ascendancyRighteousShield, (LivingEntity)player)) {
                ability_success = AscendancyAbilities.righteousShield(player);
                ability = "RighteousShield";
            }
            if (HelperMethods.isUnlocked(ascendancyTree, SkillReferencePosition.ascendancyChainbreaker, (LivingEntity)player)) {
                ability_success = ascendancyTree.equals("puffish_skills:prom") ? ProminenceAbilities.promDissonance(player) : AscendancyAbilities.chainbreaker(player);
                ability = "Chainbreaker";
            }
        }
        if (ability_success && FabricLoader.getInstance().isModLoaded("simplyswords")) {
            SimplySwordsGemEffects.doGenericAbilityGemEffects(player);
        }
        if (!player.m_9236_().f_46443_) {
            SignatureAbilities.signatureAbilityCooldownManager(ability, ability_success, player);
        }
    }

    public static void signatureAbilityCooldownManager(String ability, boolean useSuccess, Player player) {
        double spellHaste;
        double sendCooldown;
        float spellHasteCDReduce = SimplySkills.generalConfig.spellHasteCooldownReductionModifier;
        int minimumCD = SimplySkills.generalConfig.minimumAchievableCooldown * 1000;
        int useDelay = (int)SimplySkills.generalConfig.minimumTimeBetweenAbilityUse * 1000;
        int cooldown = 500;
        String type = "";
        String cooldownType = "none";
        switch (ability) {
            case "ArcaneBolt": {
                cooldown = SimplySkills.wizardConfig.signatureWizardArcaneBoltCooldown * 1000;
                type = "magic, arcane";
                cooldownType = "signature";
                break;
            }
            case "IceComet": {
                cooldown = SimplySkills.wizardConfig.signatureWizardIceCometCooldown * 1000;
                type = "magic, elemental, debuff";
                cooldownType = "signature";
                break;
            }
            case "MeteorShower": {
                cooldown = SimplySkills.wizardConfig.signatureWizardMeteorShowerCooldown * 1000;
                type = "magic, elemental";
                cooldownType = "signature";
                break;
            }
            case "StaticDischarge": {
                cooldown = SimplySkills.wizardConfig.signatureWizardStaticDischargeCooldown * 1000;
                type = "magic, elemental, debuff";
                cooldownType = "signature";
                break;
            }
            case "Berserking": {
                cooldown = SimplySkills.berserkerConfig.signatureBerserkerBerserkingCooldown * 1000;
                type = "physical, melee, buff, sacrificial";
                cooldownType = "signature";
                break;
            }
            case "Bloodthirsty": {
                cooldown = SimplySkills.berserkerConfig.signatureBerserkerBloodthirstyCooldown * 1000;
                type = "physical, melee, buff, recovery";
                cooldownType = "signature";
                break;
            }
            case "Rampage": {
                cooldown = SimplySkills.berserkerConfig.signatureBerserkerRampageCooldown * 1000;
                type = "physical, melee, buff";
                cooldownType = "signature";
                break;
            }
            case "SiphoningStrikes": {
                cooldown = SimplySkills.rogueConfig.signatureRogueSiphoningStrikesCooldown * 1000;
                type = "physical, melee, buff, debuff, recovery";
                cooldownType = "signature";
                break;
            }
            case "Evasion": {
                cooldown = SimplySkills.rogueConfig.signatureRogueEvasionCooldown * 1000;
                type = "physical, buff";
                cooldownType = "signature";
                break;
            }
            case "Preparation": {
                cooldown = SimplySkills.rogueConfig.signatureRoguePreparationCooldown * 1000;
                type = "physical, buff";
                cooldownType = "signature";
                break;
            }
            case "ArrowRain": {
                cooldown = SimplySkills.rangerConfig.effectRangerArrowRainCooldown * 1000;
                type = "physical, arrow, buff";
                cooldownType = "signature";
                break;
            }
            case "Disengage": {
                cooldown = SimplySkills.rangerConfig.signatureRangerDisengageCooldown * 1000;
                type = "physical, debuff";
                cooldownType = "signature";
                break;
            }
            case "ElementalArrows": {
                cooldown = SimplySkills.rangerConfig.effectRangerElementalArrowsCooldown * 1000;
                type = "magic, arrow, elemental, buff";
                cooldownType = "signature";
                break;
            }
            case "ElementalImpact": {
                cooldown = SimplySkills.spellbladeConfig.signatureSpellbladeElementalImpactCooldown * 1000;
                type = "magic, melee, charge, elemental";
                cooldownType = "signature";
                break;
            }
            case "ElementalSurge": {
                cooldown = SimplySkills.spellbladeConfig.signatureSpellbladeElementalSurgeCooldown * 1000;
                type = "magic, elemental, buff";
                cooldownType = "signature";
                break;
            }
            case "Spellweaver": {
                cooldown = SimplySkills.spellbladeConfig.signatureSpellbladeSpellweaverCooldown * 1000;
                type = "magic, buff, elemental, melee";
                cooldownType = "signature";
                break;
            }
            case "HeavensmithsCall": {
                cooldown = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallCooldown * 1000;
                type = "physical, debuff";
                cooldownType = "signature";
                break;
            }
            case "SacredOnslaught": {
                cooldown = SimplySkills.crusaderConfig.signatureCrusaderSacredOnslaughtCooldown * 1000;
                type = "physical, melee, charge, buff, recovery";
                cooldownType = "signature";
                break;
            }
            case "Consecration": {
                cooldown = SimplySkills.crusaderConfig.signatureCrusaderConsecrationCooldown * 1000;
                type = "magic, buff, recovery";
                cooldownType = "signature";
                break;
            }
            case "DivineIntervention": {
                cooldown = SimplySkills.clericConfig.signatureClericDivineInterventionCooldown * 1000;
                type = "magic, healing, buff";
                cooldownType = "signature";
                break;
            }
            case "SacredOrb": {
                cooldown = SimplySkills.clericConfig.signatureClericSacredOrbCooldown * 1000;
                type = "magic, healing, buff";
                cooldownType = "signature";
                break;
            }
            case "AnointWeapon": {
                cooldown = SimplySkills.clericConfig.signatureClericAnointWeaponCooldown * 1000;
                type = "magic, healing, buff";
                cooldownType = "signature";
                break;
            }
            case "SummoningRitual": {
                cooldown = SimplySkills.necromancerConfig.signatureNecromancerSummoningRitualCooldown * 1000;
                type = "magic, minion";
                cooldownType = "signature";
                break;
            }
            case "RighteousHammers": {
                cooldown = 60000;
                type = "physical, buff";
                cooldownType = "ascendancy";
                break;
            }
            case "BoneArmor": {
                cooldown = FabricLoader.getInstance().isModLoaded("prominent") ? 40000 : 70000;
                type = "physical, buff, recovery";
                cooldownType = "ascendancy";
                break;
            }
            case "CyclonicCleave": {
                cooldown = 15000;
                type = "physical, magic, melee, channel";
                cooldownType = "ascendancy";
                break;
            }
            case "MagicCircle": {
                cooldown = 40000;
                type = "buff, magic";
                cooldownType = "ascendancy";
                break;
            }
            case "ArcaneSlash": {
                cooldown = 10000;
                type = "magic, melee,";
                cooldownType = "ascendancy";
                break;
            }
            case "Agony": {
                cooldown = 40000;
                type = "magic, debuff, healing";
                cooldownType = "ascendancy";
                break;
            }
            case "Torment": {
                cooldown = 40000;
                type = "magic, debuff";
                cooldownType = "ascendancy";
                break;
            }
            case "Rapidfire": {
                cooldown = 30000;
                type = "physical, arrow, channel";
                cooldownType = "ascendancy";
                break;
            }
            case "Cataclysm": {
                cooldown = 60000;
                type = "magic, channel, elemental";
                cooldownType = "ascendancy";
                break;
            }
            case "Ghostwalk": {
                cooldown = 30000;
                type = "magic, channel, soul";
                cooldownType = "ascendancy";
                break;
            }
            case "SkywardSunder": {
                cooldown = 16000;
                type = "melee, channel, buff, physical, magic";
                cooldownType = "ascendancy";
                break;
            }
            case "RighteousShield": {
                cooldown = 6000;
                type = "physical, magic, buff";
                cooldownType = "ascendancy";
                break;
            }
            case "Chainbreaker": {
                cooldown = 45000;
                type = "physical, magic, buff";
                cooldownType = "ascendancy";
            }
        }
        if (FabricLoader.getInstance().isModLoaded("simplyswords")) {
            cooldown = SimplySwordsGemEffects.renewed(player, cooldown, minimumCD);
            cooldown = SimplySwordsGemEffects.accelerant(player, cooldown, minimumCD);
        }
        if ((sendCooldown = (double)cooldown - (spellHaste = (double)SpellPower.getHaste((LivingEntity)player)) * (double)(2000.0f * spellHasteCDReduce)) < (double)minimumCD && useSuccess) {
            sendCooldown = minimumCD;
        }
        if (!useSuccess) {
            sendCooldown = useDelay;
        }
        SignatureAbilities.sendCooldownPacket((ServerPlayer)player, (int)sendCooldown, cooldownType);
    }

    public static void castSpellEngineDumbFire(Player player, String spellIdentifier) {
        SpellCast.Action action = SpellCast.Action.RELEASE;
        ResourceLocation spellID = new ResourceLocation(spellIdentifier);
        ArrayList list = new ArrayList();
        SpellHelper.performSpell((Level)player.m_9236_(), (Player)player, (ResourceLocation)spellID, list, (SpellCast.Action)action, (float)20.0f);
    }

    public static void castSpellEngine(Player player, String spellIdentifier) {
        ItemStack itemStack = player.m_21205_();
        ResourceLocation spellID = new ResourceLocation(spellIdentifier);
        SpellHelper.attemptCasting((Player)player, (ItemStack)itemStack, (ResourceLocation)spellID, (boolean)false);
    }

    public static void castSpellEngineIndirectTarget(Player player, String spellIdentifier, int range, @Nullable Entity target, @Nullable BlockPos blockpos) {
        if (target == null && blockpos != null) {
            target = EntityRegistry.SPELL_TARGET_ENTITY.m_262496_((ServerLevel)player.m_9236_(), blockpos, MobSpawnType.TRIGGERED);
        } else if (target == null && blockpos == null && (blockpos = HelperMethods.getBlockLookingAt(player, range)) != null) {
            target = EntityRegistry.SPELL_TARGET_ENTITY.m_262496_((ServerLevel)player.m_9236_(), blockpos, MobSpawnType.TRIGGERED);
        }
        if (target != null) {
            ItemStack itemStack = player.m_21205_();
            InteractionHand hand = player.m_7655_();
            SpellCast.Action action = SpellCast.Action.RELEASE;
            ResourceLocation spellID = new ResourceLocation(spellIdentifier);
            ArrayList<Entity> list = new ArrayList<Entity>();
            list.add(target);
            SpellHelper.performSpell((Level)player.m_9236_(), (Player)player, (ResourceLocation)spellID, list, (SpellCast.Action)action, (float)1.0f);
        }
    }

    public static boolean castSpellEngineAOE(Player player, String spellIdentifier, int radius, int chance, boolean singleTarget, boolean ignorePassive) {
        ItemStack itemStack = player.m_21205_();
        InteractionHand hand = player.m_7655_();
        SpellCast.Action action = SpellCast.Action.RELEASE;
        ResourceLocation spellID = new ResourceLocation(spellIdentifier);
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        AABB box = HelperMethods.createBox((Entity)player, radius);
        for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
            LivingEntity le;
            if (entities == null || entities instanceof AgeableMob && ignorePassive || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
            if (player.m_217043_().m_188503_(100) < chance) {
                list.add(le);
            }
            if (!singleTarget) continue;
            break;
        }
        if (!list.isEmpty()) {
            SpellHelper.performSpell((Level)player.m_9236_(), (Player)player, (ResourceLocation)spellID, list, (SpellCast.Action)action, (float)20.0f);
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendKeybindPacket(String type) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130070_(type);
        ServerboundCustomPayloadPacket packet = new ServerboundCustomPayloadPacket(KeybindPacket.ABILITY1_PACKET, buf);
        Minecraft.m_91087_().m_91403_().m_104955_((Packet)packet);
    }

    public static void sendCooldownPacket(ServerPlayer player, int cooldown, String cooldownType) {
        FriendlyByteBuf buf = PacketByteBufs.create();
        buf.writeInt(cooldown);
        buf.m_130070_(cooldownType);
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(CooldownPacket.COOLDOWN_PACKET, buf);
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)CooldownPacket.COOLDOWN_PACKET, (FriendlyByteBuf)packet.m_132045_());
    }
}

