/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class WarriorAbilities {
    public static void passiveWarriorSpellbreaker(Player player) {
        int spellbreakingDuration = SimplySkills.warriorConfig.passiveWarriorSpellbreakerDuration;
        int spellbreakingChance = SimplySkills.warriorConfig.passiveWarriorSpellbreakerChance;
        if (player.m_217043_().m_188503_(100) < spellbreakingChance) {
            player.m_7292_(new MobEffectInstance(EffectRegistry.SPELLBREAKING, spellbreakingDuration, 0, false, false, true));
        }
    }

    public static void passiveWarriorSpellbreakerOnHit(Player player) {
        int spellbreakingDuration = SimplySkills.warriorConfig.passiveWarriorSpellbreakerDuration;
        int spellbreakingChance = SimplySkills.warriorConfig.passiveWarriorSpellbreakerChance;
        if (player.m_217043_().m_188503_(100) < spellbreakingChance) {
            player.m_7292_(new MobEffectInstance(EffectRegistry.RAGINGJAVELIN, spellbreakingDuration / 2, 0, false, false, true));
        }
    }

    public static void passiveWarriorDeathDefy(Player player) {
        float playerHealthPercent;
        int deathDefyFrequency = SimplySkills.warriorConfig.passiveWarriorDeathDefyFrequency;
        int deathDefyAmplifierPerTenPercentHealth = SimplySkills.warriorConfig.passiveWarriorDeathDefyAmplifierPerTenPercentHealth;
        int regen = 0;
        int healthThreshold = SimplySkills.warriorConfig.passiveWarriorDeathDefyHealthThreshold;
        if (player.f_19797_ % deathDefyFrequency == 0 && (playerHealthPercent = player.m_21223_() / player.m_21233_() * 100.0f) < (float)healthThreshold) {
            if (playerHealthPercent < (float)(healthThreshold - 10)) {
                regen += deathDefyAmplifierPerTenPercentHealth;
            }
            if (playerHealthPercent < (float)(healthThreshold - 20)) {
                regen += deathDefyAmplifierPerTenPercentHealth * 2;
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, deathDefyFrequency + 5, regen, false, false, true));
            if (player.m_21023_(MobEffects.f_19605_) && player.m_21124_(MobEffects.f_19605_).m_19564_() > 0) {
                HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.EXHAUSTION, deathDefyFrequency + 60, regen + 1, 49);
            }
        }
    }

    public static void passiveWarriorGoliath(Player player) {
        player.m_7292_(new MobEffectInstance(EffectRegistry.EARTHSHAKER, 200, 0, false, false, true));
    }

    public static void passiveWarriorArmorMastery(Player player) {
        int armorMasteryThreshold = SimplySkills.warriorConfig.passiveWarriorArmorMasteryArmorThreshold - 1;
        int armorMasteryChance = SimplySkills.warriorConfig.passiveWarriorArmorMasteryChance;
        int heavyArmorMasteryDuration = SimplySkills.warriorConfig.passiveWarriorHeavyArmorMasteryDuration;
        int heavyArmorMasteryAmplifier = SimplySkills.warriorConfig.passiveWarriorHeavyArmorMasteryAmplifier;
        int mediumArmorMasteryDuration = SimplySkills.warriorConfig.passiveWarriorMediumArmorMasteryDuration;
        int mediumArmorMasteryAmplifier = SimplySkills.warriorConfig.passiveWarriorMediumArmorMasteryAmplifier;
        if (player.m_217043_().m_188503_(100) < armorMasteryChance) {
            if (player.m_21230_() > armorMasteryThreshold && HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.warriorHeavyArmorMastery, (LivingEntity)player)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, heavyArmorMasteryDuration, heavyArmorMasteryAmplifier, false, false, true));
            } else if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.warriorMediumArmorMastery, (LivingEntity)player)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, mediumArmorMasteryDuration, mediumArmorMasteryAmplifier, false, false, true));
            }
        }
    }

    public static void passiveWarriorFrenzy(Player player) {
        int frenzyDuration = SimplySkills.warriorConfig.passiveWarriorFrenzyExhaustionDuration;
        int frenzyStacks = SimplySkills.warriorConfig.passiveWarriorFrenzyExhaustionStacks;
        HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.EXHAUSTION, frenzyDuration, frenzyStacks, 79);
    }

    public static void passiveWarriorCarnage(Player player) {
        int frequency = 15;
        int amount = (int)player.m_21233_() / 10;
        if (player.f_19797_ % frequency == 0) {
            if (player.m_21023_(EffectRegistry.EXHAUSTION) && player.m_21124_(EffectRegistry.EXHAUSTION).m_19564_() >= 75) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19616_, frequency + 5, amount, false, false, true));
                player.m_7292_(new MobEffectInstance(EffectRegistry.IMMOBILIZINGAURA, frequency + 5, amount, false, false, true));
            }
            if (player.m_21023_(EffectRegistry.RAGE) && player.m_21124_(EffectRegistry.RAGE).m_19564_() >= 75) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19616_, frequency + 5, amount, false, false, true));
                player.m_7292_(new MobEffectInstance(EffectRegistry.IMMOBILIZINGAURA, frequency + 5, amount, false, false, true));
            }
        }
    }

    public static void passiveWarriorShieldMastery(Player player) {
        int shieldMasteryFrequency = SimplySkills.warriorConfig.passiveWarriorShieldMasteryFrequency;
        int shieldMasteryWeaknessAmplifier = SimplySkills.warriorConfig.passiveWarriorShieldMasteryWeaknessAmplifier;
        int shieldMasteryResistanceAmplifier = SimplySkills.warriorConfig.passiveWarriorShieldMasteryResistanceAmplifier;
        int shieldMasteryResistanceAmplifierPerTier = SimplySkills.warriorConfig.passiveWarriorShieldMasteryResistanceAmplifierPerTier;
        if (player.f_19797_ % shieldMasteryFrequency == 0 && player.m_21206_() != null && player.m_21206_().m_41720_() instanceof ShieldItem) {
            int mastery = shieldMasteryResistanceAmplifier;
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.bulwarkShieldMasterySkilled, (LivingEntity)player)) {
                mastery += shieldMasteryResistanceAmplifierPerTier * 2;
            } else if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.bulwarkShieldMasteryProficient, (LivingEntity)player)) {
                mastery += shieldMasteryResistanceAmplifierPerTier;
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, shieldMasteryFrequency + 5, mastery, false, false, true));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, shieldMasteryFrequency + 5, shieldMasteryWeaknessAmplifier, false, false, true));
        }
    }

    public static void passiveWarriorRebuke(Player player, LivingEntity attacker) {
        int rebukeChance = SimplySkills.warriorConfig.passiveWarriorRebukeChance;
        int rebukeWeaknessDuration = SimplySkills.warriorConfig.passiveWarriorRebukeWeaknessDuration;
        int rebukeWeaknessAmplifier = SimplySkills.warriorConfig.passiveWarriorRebukeWeaknessAmplifier;
        if (player.m_217043_().m_188503_(100) < rebukeChance) {
            attacker.m_7292_(new MobEffectInstance(MobEffects.f_19613_, rebukeWeaknessDuration, rebukeWeaknessAmplifier, false, false, true));
        }
    }

    public static void passiveWarriorTwinstrike(Player player, LivingEntity target) {
        int effectChance = SimplySkills.warriorConfig.passiveWarriorTwinstrikeChance;
        int effectDamage = (int)player.m_21133_(Attributes.f_22281_);
        DamageSource damageSource = player.m_269291_().m_269075_(player);
        if (player.m_21023_(MobEffects.f_19616_)) {
            effectChance *= 2;
        }
        if (player.m_217043_().m_188503_(100) < effectChance) {
            target.m_6469_(damageSource, (float)effectDamage);
            target.f_19802_ = 0;
        }
    }

    public static void passiveWarriorSwordfall(Player player, LivingEntity target) {
        if (player.m_21205_().m_41720_() instanceof SwordItem || player.m_21205_().m_41720_() instanceof AxeItem) {
            int effectChance = SimplySkills.warriorConfig.passiveWarriorSwordfallChance;
            if (FabricLoader.getInstance().isModLoaded("prominent") && player.m_21023_(EffectRegistry.TITANSGRIP)) {
                effectChance *= 2;
            } else if (!FabricLoader.getInstance().isModLoaded("prominent") && player.m_21023_(EffectRegistry.MIGHT)) {
                effectChance *= 2;
            }
            if (player.m_217043_().m_188503_(100) < effectChance) {
                if (FabricLoader.getInstance().isModLoaded("prominent")) {
                    SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:physical_eldritch_hammers", 32, (Entity)target, null);
                } else {
                    SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:physical_swordfall", 32, (Entity)target, null);
                }
            }
        }
    }
}

