/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.RogueAbilities;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class WayfarerAbilities {
    public static void passiveWayfarerBreakStealth(Entity target, Player player, Boolean brokenByDamage, Boolean backstabBonus) {
        if (player.m_21023_(EffectRegistry.STEALTH)) {
            if (brokenByDamage.booleanValue()) {
                int speedDuration = SimplySkills.rogueConfig.passiveRogueFleetfootedSpeedDuration;
                int speedStacks = SimplySkills.rogueConfig.passiveRogueFleetfootedSpeedStacks;
                int speedMaxStacks = SimplySkills.rogueConfig.passiveRogueFleetfootedSpeedMaxStacks;
                int evasionDuration = SimplySkills.wayfarerConfig.passiveWayfarerReflexiveEvasionDuration;
                int evasionChance = SimplySkills.wayfarerConfig.passiveWayfarerReflexiveChance;
                if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueFleetfooted, (LivingEntity)player)) {
                    HelperMethods.incrementStatusEffect((LivingEntity)player, MobEffects.f_19596_, speedDuration, speedStacks, speedMaxStacks);
                }
                if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wayfarerReflexive, (LivingEntity)player) && player.m_217043_().m_188503_(100) < evasionChance) {
                    HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.EVASION, evasionDuration, 1, 1);
                }
            }
            if (!brokenByDamage.booleanValue()) {
                if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wayfarerReflexive, (LivingEntity)player)) {
                    HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.MIGHT, 40, 1, 20);
                    HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.MARKSMANSHIP, 40, 1, 20);
                }
                if (target != null && target instanceof LivingEntity) {
                    LivingEntity livingTarget = (LivingEntity)target;
                    int deathmarkDuration = SimplySkills.rogueConfig.passiveRogueExploitationDeathMarkDuration;
                    int deathmarkStacks = SimplySkills.rogueConfig.passiveRogueExploitationDeathMarkStacks;
                    if (backstabBonus.booleanValue() && HelperMethods.isBehindTarget((LivingEntity)player, livingTarget)) {
                        if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueExploitation, (LivingEntity)player)) {
                            HelperMethods.incrementStatusEffect(livingTarget, EffectRegistry.DEATHMARK, deathmarkDuration, deathmarkStacks, 3);
                        }
                        if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueOpportunisticMastery, (LivingEntity)player)) {
                            RogueAbilities.passiveRogueOpportunisticMastery((Entity)livingTarget, player);
                        }
                    }
                }
            }
            player.m_21195_(EffectRegistry.STEALTH);
            player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SOUNDEFFECT36, SoundSource.PLAYERS, 0.7f, 1.4f);
            if (player.m_21023_(MobEffects.f_19609_)) {
                player.m_21195_(MobEffects.f_19609_);
            }
            player.m_7292_(new MobEffectInstance(EffectRegistry.REVEALED, 180, 5, false, false, true));
        }
    }

    public static void passiveWayfarerGuarding(Player player) {
        int barrierFrequency = SimplySkills.wayfarerConfig.passiveWayfarerGuardingBarrierFrequency;
        int barrierDuration = SimplySkills.wayfarerConfig.passiveWayfarerGuardingBarrierDuration;
        int barrierStacks = SimplySkills.wayfarerConfig.passiveWayfarerGuardingBarrierStacks;
        int barrierMaxStacks = SimplySkills.wayfarerConfig.passiveWayfarerGuardingBarrierMaxStacks;
        if (player.m_21206_().m_41720_() instanceof CrossbowItem && player.f_19797_ % barrierFrequency == 0) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.BARRIER, barrierDuration, barrierStacks, barrierMaxStacks);
        }
    }

    public static void passiveWayfarerSlender(Player player) {
        int slenderArmorThreshold = SimplySkills.wayfarerConfig.passiveWayfarerSlenderArmorThreshold;
        int frailArmorThreshold = SimplySkills.initiateConfig.passiveInitiateFrailArmorThreshold;
        if (player.f_19797_ % 20 == 0) {
            int buffAmplifier;
            int armorValue = player.m_21230_();
            if (armorValue < slenderArmorThreshold && (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.roguePath, (LivingEntity)player) || HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.rangerPath, (LivingEntity)player))) {
                buffAmplifier = (slenderArmorThreshold - armorValue) / 5;
                player.m_7292_(new MobEffectInstance(EffectRegistry.AGILE, 25, buffAmplifier, false, false, false));
            }
            if (armorValue < frailArmorThreshold && HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wizardPath, (LivingEntity)player)) {
                buffAmplifier = (frailArmorThreshold - armorValue) / 5;
                player.m_7292_(new MobEffectInstance(EffectRegistry.AGILE, 25, buffAmplifier, false, false, false));
            }
        }
    }

    public static boolean passiveWayfarerStealth(Player player) {
        return HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wayfarerStealth, (LivingEntity)player) && player.m_6144_() && !player.m_21023_(EffectRegistry.REVEALED) && !WayfarerAbilities.isPlayerTargeted(player, 20);
    }

    public static boolean isPlayerTargeted(Player player, int radius) {
        Level world = player.m_9236_();
        AABB box = new AABB(player.m_20185_() - (double)radius, player.m_20186_() - (double)radius, player.m_20189_() - (double)radius, player.m_20185_() + (double)radius, player.m_20186_() + (double)radius, player.m_20189_() + (double)radius);
        for (Entity entity2 : world.m_6249_((Entity)player, box, entity -> entity instanceof Mob)) {
            Mob mobEntity;
            LivingEntity target;
            if (!(entity2 instanceof Mob) || (target = (mobEntity = (Mob)entity2).m_5448_()) != player) continue;
            return true;
        }
        for (Entity entity2 : world.m_6249_((Entity)player, box, entity -> entity instanceof Player)) {
            Player otherPlayer;
            if (!(entity2 instanceof Player) || (otherPlayer = (Player)entity2) == player || !WayfarerAbilities.isInViewingAngle(otherPlayer, player)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInViewingAngle(Player viewer, Player target) {
        double threshold;
        Vec3 viewerPos = viewer.m_20182_();
        Vec3 targetPos = target.m_20182_();
        Vec3 directionToTarget = targetPos.m_82546_(viewerPos).m_82541_();
        Vec3 viewerLookVec = viewer.m_20252_(1.0f).m_82541_();
        double dotProduct = viewerLookVec.m_82526_(directionToTarget);
        return dotProduct > (threshold = Math.cos(Math.toRadians(90.0)));
    }
}

