/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellHelper;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.AbilityLogic;
import net.sweenus.simplyskills.abilities.AscendancyAbilities;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.effects.StaticChargeEffect;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class WizardAbilities {
    public static void passiveWizardSpellEcho(Player player, List<Entity> targets) {
        Entity target = null;
        if (!targets.isEmpty()) {
            target = targets.get(player.m_217043_().m_188503_(targets.size()));
        }
        int chance = SimplySkills.wizardConfig.passiveWizardSpellEchoChance;
        if (AscendancyAbilities.magicCircleEffect(player)) {
            chance += 10;
        }
        if (player.m_217043_().m_188503_(100) < chance) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("simplyskills:frost_arrow");
            list.add("simplyskills:fire_arrow");
            list.add("simplyskills:lightning_arrow");
            list.add("simplyskills:arcane_bolt_lesser");
            list.add("simplyskills:ice_comet");
            list.add("simplyskills:fire_meteor");
            list.add("simplyskills:static_discharge");
            int spellChoice = player.m_217043_().m_188503_(list.size());
            if (target != null) {
                SignatureAbilities.castSpellEngineIndirectTarget(player, (String)list.get(spellChoice), 120, target, null);
            }
        }
    }

    public static boolean signatureWizardMeteorShower(String wizardSkillTree, Player player) {
        Vec3 blockpos = null;
        boolean success = false;
        int meteoricWrathDuration = SimplySkills.wizardConfig.signatureWizardMeteoricWrathDuration;
        int meteoricWrathStacks = SimplySkills.wizardConfig.signatureWizardMeteoricWrathStacks - 1;
        int meteorShowerRange = SimplySkills.wizardConfig.signatureWizardMeteorShowerRange;
        if (HelperMethods.getTargetedEntity((Entity)player, meteorShowerRange) != null) {
            blockpos = HelperMethods.getTargetedEntity((Entity)player, meteorShowerRange).m_20182_();
        }
        if (blockpos == null) {
            blockpos = HelperMethods.getPositionLookingAt(player, meteorShowerRange);
        }
        if (blockpos != null) {
            int xpos = (int)blockpos.m_7096_();
            int ypos = (int)blockpos.m_7098_();
            int zpos = (int)blockpos.m_7094_();
            BlockPos searchArea = new BlockPos(xpos, ypos, zpos);
            AABB box = HelperMethods.createBoxAtBlock(searchArea, 8);
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                success = true;
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationMeteorShowerWrath, (LivingEntity)player)) {
                    player.m_7292_(new MobEffectInstance(EffectRegistry.METEORICWRATH, meteoricWrathDuration, meteoricWrathStacks, false, false, true));
                }
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationMeteorShowerGreater, (LivingEntity)player)) {
                    SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:fire_meteor_large", 8, (Entity)le, searchArea);
                    break;
                }
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:fire_meteor", 8, (Entity)le, searchArea);
                break;
            }
        }
        return success;
    }

    public static boolean signatureWizardIceComet(String wizardSkillTree, Player player) {
        Vec3 blockpos = null;
        boolean success = false;
        LivingEntity target = null;
        int leapVelocity = SimplySkills.wizardConfig.signatureWizardIceCometLeapVelocity;
        double leapHeight = SimplySkills.wizardConfig.signatureWizardIceCometLeapHeight;
        int leapSlowfallDuration = SimplySkills.wizardConfig.signatureWizardIceCometLeapSlowfallDuration;
        int volleyDuration = SimplySkills.wizardConfig.signatureWizardIceCometVolleyDuration;
        int volleyStacks = SimplySkills.wizardConfig.signatureWizardIceCometVolleyStacks;
        int iceCometRange = SimplySkills.wizardConfig.signatureWizardIceCometRange;
        if (HelperMethods.getTargetedEntity((Entity)player, iceCometRange) != null) {
            blockpos = HelperMethods.getTargetedEntity((Entity)player, iceCometRange).m_20182_();
        }
        if (blockpos == null) {
            blockpos = HelperMethods.getPositionLookingAt(player, iceCometRange);
        }
        if (blockpos != null) {
            int xpos = (int)blockpos.m_7096_();
            int ypos = (int)blockpos.m_7098_();
            int zpos = (int)blockpos.m_7094_();
            BlockPos searchArea = new BlockPos(xpos, ypos, zpos);
            AABB box = HelperMethods.createBoxAtBlock(searchArea, 3);
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (!(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                target = le;
                break;
            }
            if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceCometLeap, (LivingEntity)player)) {
                player.m_20256_(player.m_20154_().m_82548_().m_82490_((double)leapVelocity));
                player.m_20334_(player.m_20184_().f_82479_, leapHeight, player.m_20184_().f_82481_);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, leapSlowfallDuration, 0, false, false, true));
                player.f_19864_ = true;
            }
            if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceCometVolley, (LivingEntity)player)) {
                player.m_7292_(new MobEffectInstance(EffectRegistry.FROSTVOLLEY, volleyDuration, volleyStacks, false, false, true));
            }
            if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceCometDamageOne, (LivingEntity)player)) {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:ice_comet_large", 3, (Entity)target, searchArea);
            } else if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceCometDamageTwo, (LivingEntity)player)) {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:ice_comet_large_two", 3, (Entity)target, searchArea);
            } else if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceCometDamageThree, (LivingEntity)player)) {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:ice_comet_large_three", 3, (Entity)target, searchArea);
            } else {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:ice_comet", 3, (Entity)target, searchArea);
            }
        }
        if (blockpos != null || target != null) {
            success = true;
        }
        return success;
    }

    public static boolean signatureWizardStaticDischarge(String wizardSkillTree, Player player) {
        Vec3 blockpos = null;
        boolean success = false;
        int amplifier = SimplySkills.wizardConfig.signatureWizardStaticDischargeBaseLeaps;
        int leapsPerTier = SimplySkills.wizardConfig.signatureWizardStaticDischargeLeapsPerTier;
        int staticDischargeRange = SimplySkills.wizardConfig.signatureWizardStaticDischargeRange;
        int staticChargeDuration = SimplySkills.wizardConfig.signatureWizardStaticChargeDuration;
        if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischargeLeapTwo, (LivingEntity)player)) {
            amplifier += leapsPerTier;
        } else if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischargeLeapThree, (LivingEntity)player)) {
            amplifier += leapsPerTier * 2;
        }
        if (HelperMethods.getTargetedEntity((Entity)player, staticDischargeRange) != null) {
            blockpos = HelperMethods.getTargetedEntity((Entity)player, staticDischargeRange).m_20182_();
        }
        if (blockpos == null) {
            blockpos = HelperMethods.getPositionLookingAt(player, staticDischargeRange);
        }
        if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischargeLightningBall, (LivingEntity)player)) {
            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:lightning_ball", 3, null, null);
            success = true;
        } else if (blockpos != null) {
            int xpos = (int)blockpos.m_7096_();
            int ypos = (int)blockpos.m_7098_();
            int zpos = (int)blockpos.m_7094_();
            BlockPos searchArea = new BlockPos(xpos, ypos, zpos);
            AABB box = HelperMethods.createBoxAtBlock(searchArea, 3);
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                success = true;
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:static_discharge", 3, (Entity)le, searchArea);
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischargeLeap, (LivingEntity)player)) {
                    le.m_7292_(new MobEffectInstance(EffectRegistry.STATICCHARGE, staticChargeDuration, amplifier, false, false, true));
                }
                StaticChargeEffect.onHitEffects(player, StaticChargeEffect.calculateSpeedChance(player), le);
                break;
            }
        }
        return success;
    }

    public static void signatureWizardStaticDischargeBall(ServerPlayer player, SpellProjectile spellProjectile, ResourceLocation spellId, SpellHelper.ImpactContext context, Spell.ProjectileData.Perks perks) {
        if (player != null && spellProjectile.f_19797_ % 5 == 0 && spellProjectile.f_19797_ > 5 && (spellId.toString().contains("lightning_ball") || spellId.toString().contains("lightning_lesser"))) {
            if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationStaticDischargeLightningBall, (LivingEntity)player)) {
                Vec3 position = spellProjectile.m_20182_();
                if (!spellId.toString().contains("ball_homing")) {
                    perks.pierce = 132;
                    SpellProjectile projectile = new SpellProjectile(spellProjectile.m_9236_(), (LivingEntity)spellProjectile.m_19749_(), position.m_7096_(), position.m_7098_(), position.m_7094_(), spellProjectile.behaviour(), new ResourceLocation("simplyskills:lightning_lesser"), (Entity)null, context, perks.copy());
                    projectile.m_20256_(spellProjectile.m_20184_().m_82490_(5.0));
                    projectile.range = spellProjectile.range;
                    ProjectileUtil.m_37284_((Entity)projectile, (float)0.2f);
                    int radius = 5;
                    ArrayList<Entity> targets = new ArrayList<Entity>();
                    AABB box = new AABB(spellProjectile.m_20185_() + (double)radius, spellProjectile.m_20186_() + (double)((float)radius / 2.0f), spellProjectile.m_20189_() + (double)radius, spellProjectile.m_20185_() - (double)radius, spellProjectile.m_20186_() - (double)((float)radius / 2.0f), spellProjectile.m_20189_() - (double)radius);
                    for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                        LivingEntity le;
                        if (entities == null || player.m_217043_().m_188503_(100) >= 5 || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, (Player)player)) continue;
                        projectile.setFollowedTarget((Entity)le);
                        spellProjectile.m_9236_().m_7967_((Entity)projectile);
                        targets.add((Entity)le);
                        AbilityLogic.onSpellCastEffects((Player)player, targets, spellId, null);
                        StaticChargeEffect.onHitEffects((Player)player, StaticChargeEffect.calculateSpeedChance((Player)player), le);
                        targets.clear();
                        break;
                    }
                }
            }
            if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationStaticDischargeLightningOrb, (LivingEntity)player) && spellId.toString().contains("lightning_ball")) {
                spellProjectile.setFollowedTarget((Entity)player);
                spellProjectile.range = 512.0f;
                spellProjectile.m_146926_(90.0f);
            }
        }
    }

    public static void signatureWizardLightningOrb(SpellProjectile spellProjectile, Entity followedTarget, ResourceLocation spellId) {
        if (spellId != null && spellId.toString().equals("simplyskills:lightning_ball_homing") && spellProjectile.f_19797_ % 20 == 0 && followedTarget != null && spellProjectile.m_20270_(followedTarget) > 10.0f) {
            spellProjectile.m_20324_(followedTarget.m_20185_(), followedTarget.m_20186_(), followedTarget.m_20189_());
            spellProjectile.m_146926_(90.0f);
            spellProjectile.f_19864_ = true;
        }
    }

    public static void signatureWizardLightningOrbBuff(Player player) {
        int radius = SimplySkills.wizardConfig.signatureWizardLightningOrbBuffRadius;
        int frequency = SimplySkills.wizardConfig.signatureWizardLightningOrbBuffFrequency;
        int count = 0;
        AABB box = new AABB(player.m_20185_() + (double)radius, player.m_20186_() + (double)((float)radius * 3.0f), player.m_20189_() + (double)radius, player.m_20185_() - (double)radius, player.m_20186_() - (double)((float)radius * 3.0f), player.m_20189_() - (double)radius);
        if (player.f_19797_ % frequency == 0) {
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20402_)) {
                SpellProjectile spe;
                if (entities == null || player.m_217043_().m_188503_(100) >= SimplySkills.wizardConfig.signatureWizardLightningOrbBuffChance || !(entities instanceof SpellProjectile) || (spe = (SpellProjectile)entities).m_19749_() == null || spe.m_19749_() != player) continue;
                ++count;
            }
            if (count > 0) {
                HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.SOULSHOCK, frequency + 5, count, count);
            }
        }
    }

    public static boolean signatureWizardArcaneBolt(String wizardSkillTree, Player player) {
        LivingEntity le;
        boolean success = false;
        Entity target = null;
        int volleyDuration = SimplySkills.wizardConfig.signatureWizardArcaneBoltVolleyDuration;
        int volleyStacks = SimplySkills.wizardConfig.signatureWizardArcaneBoltVolleyStacks - 1;
        int arcaneBoltRange = SimplySkills.wizardConfig.signatureWizardArcaneBoltRange;
        int radius = 3;
        if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationArcaneBoltLesser, (LivingEntity)player)) {
            radius = SimplySkills.wizardConfig.signatureWizardLesserArcaneBoltRadius;
        }
        target = HelperMethods.getTargetedEntity((Entity)player, arcaneBoltRange);
        BlockPos searchArea = HelperMethods.getBlockLookingAt(player, 512);
        if (target instanceof LivingEntity && HelperMethods.checkFriendlyFire(le = (LivingEntity)target, player) || target == null) {
            if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationArcaneBoltVolley, (LivingEntity)player)) {
                player.m_7292_(new MobEffectInstance(EffectRegistry.ARCANEVOLLEY, volleyDuration, volleyStacks, false, false, true));
            }
            if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationArcaneBoltLesser, (LivingEntity)player)) {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:arcane_bolt_expanding", radius, target, searchArea);
            } else if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationArcaneBoltGreater, (LivingEntity)player)) {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:arcane_bolt_greater", radius, target, searchArea);
            } else {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:arcane_bolt", radius, target, searchArea);
            }
            success = true;
        }
        return success;
    }
}

