/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.client.SimplySkillsClient;

public class CustomHud {
    public static ResourceLocation ICON_TEXTURE = new ResourceLocation("simplyskills", "textures/gui/ability1_icon.png");
    public static ResourceLocation ICON_TEXTURE_2 = new ResourceLocation("simplyskills", "textures/gui/ability2_icon.png");
    public static ResourceLocation FRAME_TEXTURE = new ResourceLocation("minecraft", "textures/gui/widgets.png");
    public static ResourceLocation COOLDOWN_OVERLAY = new ResourceLocation("simplyskills", "textures/gui/cooldown_overlay.png");

    public static void setSprite(ResourceLocation sprite) {
        ICON_TEXTURE = sprite;
    }

    public static void setSprite2(ResourceLocation sprite2) {
        ICON_TEXTURE_2 = sprite2;
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ == null || client.f_91074_.m_5833_() || client.m_91104_() || client.f_91080_ != null) {
            return;
        }
        int scaledWidth = client.m_91268_().m_85445_();
        int scaledHeight = client.m_91268_().m_85446_();
        int guiAnchorX = scaledWidth / 2 + 86 + SimplySkills.generalConfig.signatureHudX;
        int guiAnchorY = scaledHeight - 29 + SimplySkills.generalConfig.signatureHudY;
        this.renderAbility(context, client, guiAnchorX, guiAnchorY, SimplySkillsClient.abilityCooldown, SimplySkillsClient.lastUseTime, ICON_TEXTURE, SimplySkillsClient.bindingAbility1);
        this.renderAbility(context, client, guiAnchorX + 22, guiAnchorY, SimplySkillsClient.abilityCooldown2, SimplySkillsClient.lastUseTime2, ICON_TEXTURE_2, SimplySkillsClient.bindingAbility2);
    }

    private void renderAbility(GuiGraphics context, Minecraft client, int guiAnchorX, int guiAnchorY, int cooldown, long lastUseTime, ResourceLocation iconTexture, KeyMapping keybind) {
        long currentTime = System.currentTimeMillis();
        long timeSinceLastUse = currentTime - lastUseTime;
        long remainingCooldownMillis = Math.max(0L, lastUseTime + (long)cooldown - currentTime);
        int remainingCooldownSecs = (int)(remainingCooldownMillis / 1000L);
        Component remainingCooldownText = Component.m_130674_((String)String.valueOf(remainingCooldownSecs));
        RenderSystem._setShaderTexture((int)0, (int)0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int cooldownOverlayHeight = (int)(16.0f * ((float)remainingCooldownMillis / (float)cooldown));
        Component keybindText = keybind.m_90863_();
        if (client.f_91074_ != null && !iconTexture.toString().contains("cooldown_overlay")) {
            context.m_280163_(FRAME_TEXTURE, guiAnchorX + 5, guiAnchorY + 6, 58.0f, 22.0f, 24, 24, 256, 256);
            context.m_280163_(iconTexture, guiAnchorX + 10, guiAnchorY + 10, 0.0f, 0.0f, 16, 16, 16, 16);
            if (remainingCooldownMillis > 0L) {
                int overlayY = guiAnchorY + 10 + (16 - cooldownOverlayHeight);
                context.m_280163_(COOLDOWN_OVERLAY, guiAnchorX + 10, overlayY, 0.0f, (float)(16 - cooldownOverlayHeight), 16, cooldownOverlayHeight, 16, 16);
                context.m_280653_(client.f_91062_, remainingCooldownText, guiAnchorX + 18, guiAnchorY + 14, 0xFFFFFF);
            }
            context.m_280653_(client.f_91062_, keybindText, guiAnchorX + 18, guiAnchorY + 0, 0xFFFFFF);
        }
    }
}

