/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.effects;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsGemEffects;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class BullrushEffect
extends MobEffect {
    public BullrushEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_() && livingEntity.m_20096_() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int bullrushVelocity = SimplySkills.berserkerConfig.signatureBerserkerBullrushVelocity;
            int bullrushRadius = SimplySkills.berserkerConfig.signatureBerserkerBullrushRadius;
            double bullrushDamageModifier = SimplySkills.berserkerConfig.signatureBerserkerBullrushDamageModifier;
            int bullrushHitFrequency = SimplySkills.berserkerConfig.signatureBerserkerBullrushHitFrequency;
            int bullrushImmobilizeDuration = SimplySkills.berserkerConfig.signatureBerserkerBullrushImmobilizeDuration;
            int bullrushStrengthDuration = SimplySkills.berserkerConfig.signatureBerserkerBullrushRelentlessDuration;
            int bullrushExhaustionPerStrength = SimplySkills.berserkerConfig.signatureBerserkerBullrushRelentlessExhaustPerStrength;
            player.m_20256_(livingEntity.m_20154_().m_82490_((double)bullrushVelocity));
            player.m_20334_(livingEntity.m_20184_().f_82479_, 0.0, livingEntity.m_20184_().f_82481_);
            player.f_19864_ = true;
            int radius = bullrushRadius;
            double damage_multiplier = bullrushDamageModifier;
            double damage = HelperMethods.getAttackDamage(livingEntity.m_21205_()) * damage_multiplier;
            AABB box = HelperMethods.createBox((Entity)player, radius * 2);
            for (Entity entities : livingEntity.m_9236_().m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                le.m_20334_((player.m_20185_() - le.m_20185_()) / 4.0, (player.m_20186_() - le.m_20186_()) / 4.0, (player.m_20189_() - le.m_20189_()) / 4.0);
                if (player.f_19797_ % bullrushHitFrequency != 0) continue;
                le.m_6469_(player.m_269291_().m_269075_(player), (float)damage);
                player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SOUNDEFFECT32, SoundSource.PLAYERS, 0.6f, 1.0f);
                if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerSpecialisationRampageChargeImmob, (LivingEntity)player)) {
                    le.m_7292_(new MobEffectInstance(EffectRegistry.IMMOBILIZE, bullrushImmobilizeDuration, 0, false, false, true));
                }
                if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerSignatureRampageChargeRelentless, (LivingEntity)player) && player.m_21023_(EffectRegistry.EXHAUSTION)) {
                    int stacks = player.m_21124_(EffectRegistry.EXHAUSTION).m_19564_();
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, bullrushStrengthDuration, stacks / bullrushExhaustionPerStrength, false, false, true));
                    player.m_21195_(EffectRegistry.EXHAUSTION);
                }
                HelperMethods.spawnParticlesPlane(player.m_9236_(), (ParticleOptions)ParticleTypes.f_123796_, player.m_20183_(), radius - 2, 0.0, 1.0, 0.0);
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (FabricLoader.getInstance().isModLoaded("simplyswords")) {
                SimplySwordsGemEffects.warStandard(player);
            }
        }
        super.m_6386_(entity, attributes, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

