/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.effects;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.spell_engine.particle.Particles;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.effects.instance.SimplyStatusEffectInstance;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class ConsecrateEffect
extends MobEffect {
    public ConsecrateEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_() && livingEntity.m_20096_() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int radius = SimplySkills.crusaderConfig.signatureCrusaderConsecrationRadius;
            double damageMultiplier = SimplySkills.crusaderConfig.signatureCrusaderConsecrationDMGMultiplier;
            int hitFrequency = SimplySkills.crusaderConfig.signatureCrusaderConsecrationHitFrequency;
            double damage = SpellPower.getSpellPower((SpellSchool)SpellSchools.HEALING, (LivingEntity)player).baseValue() * damageMultiplier;
            int tauntDuration = SimplySkills.crusaderConfig.signatureCrusaderConsecrationTauntDuration;
            int mightStacks = SimplySkills.crusaderConfig.signatureCrusaderConsecrationMightStacks - 1;
            int mightStacksMax = SimplySkills.crusaderConfig.signatureCrusaderConsecrationMightStacksMax - 1;
            int spellforgedStacks = SimplySkills.crusaderConfig.signatureCrusaderConsecrationSpellforgedStacks - 1;
            int spellforgedStacksMax = SimplySkills.crusaderConfig.signatureCrusaderConsecrationSpellforgedStacksMax - 1;
            AABB box = HelperMethods.createBox((Entity)player, radius * 2);
            if (player.f_19797_ % hitFrequency == 0) {
                player.m_5634_((float)damage / 5.0f);
                for (Entity entities : livingEntity.m_9236_().m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_)) {
                    LivingEntity le;
                    if (entities == null) continue;
                    if (entities instanceof LivingEntity && HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) {
                        if (le.m_21222_() && HelperMethods.isUnlocked("simplyskills:crusader", SkillReferencePosition.crusaderSpecialisationConsecrationWard, (LivingEntity)player)) {
                            le.m_20334_((le.m_20185_() - player.m_20185_()) / 4.0, (le.m_20186_() - player.m_20186_()) / 4.0, (le.m_20189_() - player.m_20189_()) / 4.0);
                        }
                        le.f_19802_ = 0;
                        le.m_6469_(player.m_269291_().m_269104_((Entity)player, (Entity)player), (float)damage);
                        le.f_19802_ = 1;
                        if (le instanceof Mob) {
                            Mob me = (Mob)le;
                            if (HelperMethods.isUnlocked("simplyskills:crusader", SkillReferencePosition.crusaderSpecialisationConsecrationTaunt, (LivingEntity)player)) {
                                SimplyStatusEffectInstance tauntEffect = new SimplyStatusEffectInstance(EffectRegistry.TAUNTED, tauntDuration, 0, false, false, true);
                                tauntEffect.setSourceEntity(livingEntity);
                                me.m_7292_((MobEffectInstance)tauntEffect);
                            }
                        }
                    }
                    if (!(entities instanceof LivingEntity) || HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                    le.m_5634_((float)damage / 4.0f);
                    if (HelperMethods.isUnlocked("simplyskills:crusader", SkillReferencePosition.crusaderSpecialisationConsecrationMighty, (LivingEntity)player)) {
                        HelperMethods.incrementStatusEffect(le, EffectRegistry.MIGHT, hitFrequency + 1, mightStacks, mightStacksMax);
                    }
                    if (!HelperMethods.isUnlocked("simplyskills:crusader", SkillReferencePosition.crusaderSpecialisationConsecrationSpellforged, (LivingEntity)player)) continue;
                    HelperMethods.incrementStatusEffect(le, EffectRegistry.SPELLFORGED, hitFrequency + 1, spellforgedStacks, spellforgedStacksMax);
                }
            }
            if (player.f_19797_ % hitFrequency == 0) {
                HelperMethods.spawnParticlesPlane(player.m_9236_(), (ParticleOptions)Particles.holy_ascend.particleType, player.m_20183_(), radius, 0.0, 0.4, 0.0);
                HelperMethods.spawnParticlesPlane(player.m_9236_(), (ParticleOptions)Particles.holy_hit.particleType, player.m_20183_(), radius, 0.0, 0.2, 0.0);
                player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SOUNDEFFECT25, SoundSource.PLAYERS, 0.05f, 0.8f);
            }
            if (player.f_19797_ % hitFrequency - 10 == 0) {
                HelperMethods.spawnParticlesPlane(player.m_9236_(), (ParticleOptions)Particles.holy_spell.particleType, player.m_20183_(), radius, 0.0, 0.2, 0.0);
                HelperMethods.spawnParticlesPlane(player.m_9236_(), (ParticleOptions)Particles.holy_hit.particleType, player.m_20183_(), radius, 0.0, 0.3, 0.0);
            }
            if (player.f_19797_ % hitFrequency - 5 == 0) {
                HelperMethods.spawnParticlesPlane(player.m_9236_(), (ParticleOptions)Particles.holy_hit.particleType, player.m_20183_(), radius, 0.0, 0.4, 0.0);
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

