/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.effects;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class EarthshakerEffect
extends MobEffect {
    private float fallDistance;

    public EarthshakerEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_()) {
            int radius = 3;
            float damageIncrease = SimplySkills.warriorConfig.passiveWarriorHeavyWeightDamageIncreasePerTick;
            double damage_multiplier = 0.5;
            double damage = 1.0 + (double)livingEntity.m_21230_() * damage_multiplier;
            DamageSource damageSource = livingEntity.m_269291_().m_269264_();
            this.fallDistance += damageIncrease;
            if (livingEntity.m_20096_()) {
                AABB box = HelperMethods.createBox((Entity)livingEntity, radius);
                for (Entity entities : livingEntity.m_9236_().m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_)) {
                    if (entities == null || !(entities instanceof LivingEntity)) continue;
                    LivingEntity le = (LivingEntity)entities;
                    if (livingEntity.m_21023_(MobEffects.f_19591_)) continue;
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        damageSource = player.m_269291_().m_269075_(player);
                        if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.warriorHeavyWeight, (LivingEntity)player)) {
                            damage += (double)this.fallDistance;
                        }
                        if (!HelperMethods.checkFriendlyFire(le, player)) break;
                    }
                    le.m_20334_((le.m_20185_() - livingEntity.m_20185_()) / 4.0, (le.m_20186_() - livingEntity.m_20186_()) / 4.0, (le.m_20189_() - livingEntity.m_20189_()) / 4.0);
                    le.f_19802_ = 0;
                    le.m_6469_(damageSource, (float)damage);
                    le.f_19802_ = 0;
                }
                livingEntity.m_9236_().m_6269_(null, (Entity)livingEntity, SoundRegistry.SOUNDEFFECT14, SoundSource.PLAYERS, 0.3f, 1.1f);
                this.fallDistance = 0.0f;
                HelperMethods.spawnParticlesPlane(livingEntity.m_9236_(), (ParticleOptions)ParticleTypes.f_123777_, livingEntity.m_20183_(), radius, 0.0, 1.0, 0.0);
                livingEntity.m_21195_(EffectRegistry.EARTHSHAKER);
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

