/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.effects;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyskills.abilities.AscendancyAbilities;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsGemEffects;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;

public class GhostwalkEffect
extends MobEffect {
    public GhostwalkEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        ServerPlayer player;
        if (!livingEntity.m_9236_().m_5776_() && livingEntity instanceof ServerPlayer && (player = (ServerPlayer)livingEntity).m_21023_(EffectRegistry.GHOSTWALK)) {
            MobEffectInstance ghostwalk = player.m_21124_(EffectRegistry.GHOSTWALK);
            if (ghostwalk == null) {
                return;
            }
            double bullrushVelocity = 0.02 * (double)(61 - ghostwalk.m_19557_());
            int bullrushRadius = 10;
            double damageModifier = 0.8 + 0.03 * (double)AscendancyAbilities.getAscendancyPoints((Player)player);
            int bullrushHitFrequency = 5;
            HelperMethods.spawnOrbitParticles(player.m_284548_(), player.m_20182_(), (ParticleOptions)ParticleTypes.f_123762_, 1.0, 20);
            if (ghostwalk.m_19557_() % 15 == 0) {
                player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SPELL_RADIANT_EXPIRE, SoundSource.PLAYERS, 0.3f, 1.0f);
            }
            if (ghostwalk.m_19557_() > 10 && ghostwalk.m_19557_() < 57) {
                player.m_20256_(livingEntity.m_20154_().m_82490_(bullrushVelocity));
                player.m_20334_(livingEntity.m_20184_().f_82479_, 0.0, livingEntity.m_20184_().f_82481_);
                player.m_20242_(true);
                player.f_19864_ = true;
            } else if (ghostwalk.m_19557_() > 56) {
                player.m_20334_(livingEntity.m_20184_().f_82479_, livingEntity.m_20184_().f_82480_ + 0.2, livingEntity.m_20184_().f_82481_);
                player.f_19864_ = true;
            }
            double damage = HelperMethods.getHighestAttributeValue((Player)player) * damageModifier;
            AABB box = HelperMethods.createBox((Entity)player, bullrushRadius);
            int chance = 15;
            for (Entity entities : livingEntity.m_9236_().m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, (Player)player) || ghostwalk.m_19557_() % bullrushHitFrequency != 0 || ((LivingEntity)entities).m_217043_().m_188503_(100) >= chance) continue;
                le.f_19802_ = 0;
                le.m_6469_(player.m_269291_().m_269075_((Player)player), (float)damage);
                HelperMethods.spawnWaistHeightParticles((ServerLevel)player.m_9236_(), (ParticleOptions)ParticleTypes.f_123746_, (Entity)player, (Entity)le, 20);
                le.f_19802_ = 0;
                if (AscendancyAbilities.getAscendancyPoints((Player)player) > 29) {
                    player.m_5634_((float)damage / 2.0f);
                }
                return;
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        if (!entity.m_9236_().m_5776_()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (FabricLoader.getInstance().isModLoaded("simplyswords")) {
                    SimplySwordsGemEffects.warStandard(player);
                }
            }
            entity.m_20242_(false);
        }
        super.m_6386_(entity, attributes, amplifier);
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        if (!entity.m_9236_().m_5776_() && entity instanceof Player) {
            Player player = (Player)entity;
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.SOULSHOCK, 60, 1 + AscendancyAbilities.getAscendancyPoints(player) / 10, 9);
        }
        super.m_6385_(entity, attributes, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

