/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.effects;

import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsGemEffects;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsRequiredMethods;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class LeapSlamEffect
extends MobEffect {
    public LeapSlamEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int ability_timer = Objects.requireNonNull(player.m_21124_(EffectRegistry.LEAPSLAM)).m_19557_();
            int radius = SimplySkills.berserkerConfig.signatureBerserkerLeapSlamRadius;
            int immobilizeDuration = SimplySkills.berserkerConfig.signatureBerserkerLeapSlamImmobilizeDuration;
            double leapVelocity = SimplySkills.berserkerConfig.signatureBerserkerLeapSlamVelocity;
            double height = SimplySkills.berserkerConfig.signatureBerserkerLeapSlamHeight;
            double descentVelocity = SimplySkills.berserkerConfig.signatureBerserkerLeapSlamDescentVelocity;
            double damage_multiplier = SimplySkills.berserkerConfig.signatureBerserkerLeapSlamDamageModifier;
            double damage = HelperMethods.getAttackDamage(livingEntity.m_21205_()) * damage_multiplier;
            if (ability_timer >= 60) {
                player.m_20256_(livingEntity.m_20154_().m_82490_(leapVelocity));
                player.m_20334_(livingEntity.m_20184_().f_82479_, height, livingEntity.m_20184_().f_82481_);
                player.f_19864_ = true;
            } else if (ability_timer <= 50) {
                player.m_20334_(livingEntity.m_20184_().f_82479_, -descentVelocity, livingEntity.m_20184_().f_82481_);
                player.f_19864_ = true;
                if (player.m_20096_()) {
                    AABB box = HelperMethods.createBox((Entity)player, radius * 2);
                    for (Entity entities : livingEntity.m_9236_().m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_)) {
                        LivingEntity le;
                        if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                        if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerSpecialisationBerserkingLeapPull, (LivingEntity)player)) {
                            le.m_20334_((player.m_20185_() - le.m_20185_()) / 4.0, (player.m_20186_() - le.m_20186_()) / 4.0, (player.m_20189_() - le.m_20189_()) / 4.0);
                        } else {
                            le.m_20334_((le.m_20185_() - player.m_20185_()) / 4.0, (le.m_20186_() - player.m_20186_()) / 4.0, (le.m_20189_() - player.m_20189_()) / 4.0);
                        }
                        le.m_6469_(player.m_269291_().m_269075_(player), (float)damage);
                        player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SOUNDEFFECT14, SoundSource.PLAYERS, 0.3f, 1.1f);
                        if (!HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerSpecialisationBerserkingLeapImmob, (LivingEntity)player)) continue;
                        le.m_7292_(new MobEffectInstance(EffectRegistry.IMMOBILIZE, immobilizeDuration, 0, false, false, true));
                    }
                    HelperMethods.spawnParticlesPlane(player.m_9236_(), (ParticleOptions)ParticleTypes.f_123777_, player.m_20183_(), radius, 0.0, 1.0, 0.0);
                    player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SOUNDEFFECT14, SoundSource.PLAYERS, 0.5f, 0.9f);
                    if (FabricLoader.getInstance().isModLoaded("simplyswords") && SimplySwordsGemEffects.passVersionCheck()) {
                        int resetChance = SimplySwordsRequiredMethods.leapingChance;
                        if (SimplySwordsGemEffects.doSignatureGemEffects(player, "leaping") && player.m_217043_().m_188503_(100) < resetChance) {
                            player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SOUNDEFFECT15, SoundSource.PLAYERS, 0.5f, 1.1f);
                            player.m_7292_(new MobEffectInstance(EffectRegistry.LEAPSLAM, SimplySkills.berserkerConfig.signatureBerserkerLeapSlamDuration, 0, false, false, true));
                        } else {
                            player.m_21195_(EffectRegistry.LEAPSLAM);
                        }
                    } else {
                        player.m_21195_(EffectRegistry.LEAPSLAM);
                    }
                }
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

