/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.effects;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.sweenus.simplyskills.abilities.AscendancyAbilities;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsGemEffects;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;

public class RapidFireEffect
extends MobEffect {
    private int arrowCount = 0;

    public RapidFireEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        ServerPlayer player;
        if (!livingEntity.m_9236_().m_5776_() && livingEntity instanceof ServerPlayer && (player = (ServerPlayer)livingEntity).m_21023_(EffectRegistry.RAPIDFIRE) && (player.m_21205_().m_41720_() instanceof BowItem || player.m_21205_().m_41720_() instanceof CrossbowItem)) {
            MobEffectInstance rapidFire = player.m_21124_(EffectRegistry.RAPIDFIRE);
            if (rapidFire == null) {
                return;
            }
            if (rapidFire.m_19557_() % 4 == 0) {
                player.m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_12318_, SoundSource.PLAYERS, 0.6f, 1.4f);
                if (player.m_21205_().m_41720_() instanceof BowItem) {
                    SignatureAbilities.castSpellEngineIndirectTarget((Player)player, "simplyskills:rapidfire", 3, (Entity)player, null);
                } else if (player.m_21205_().m_41720_() instanceof CrossbowItem) {
                    SignatureAbilities.castSpellEngineIndirectTarget((Player)player, "simplyskills:rapidfire_crossbow", 3, (Entity)player, null);
                }
            } else if (rapidFire.m_19557_() % 5 == 0) {
                ++this.arrowCount;
                SignatureAbilities.castSpellEngineIndirectTarget((Player)player, "simplyskills:rapidfire_projectile", 3, (Entity)player, null);
            }
            if (this.arrowCount > 2 && AscendancyAbilities.getAscendancyPoints((Player)player) > 29) {
                this.arrowCount = 0;
                HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.MARKSMANSHIP, 60, 1, 12);
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (FabricLoader.getInstance().isModLoaded("simplyswords")) {
                SimplySwordsGemEffects.warStandard(player);
            }
        }
        super.m_6386_(entity, attributes, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

